% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_analysis.R
\name{ssm_analyze}
\alias{ssm_analyze}
\title{Perform analyses using the Structural Summary Method}
\usage{
ssm_analyze(.data, scales, angles, measures = NULL, grouping = NULL,
  contrast = "none", boots = 2000, interval = 0.95,
  listwise = TRUE)
}
\arguments{
\item{.data}{Required. A data frame containing at least circumplex scales.}

\item{scales}{Required. The variable names or column numbers for the
variables in \code{.data} that contain circumplex scales to be analyzed.}

\item{angles}{Required. A numeric vector containing the angular displacement
of each circumplex scale included in \code{scales} (in degrees).}

\item{measures}{Optional. The variable names or column numbers for one or
more variables in \code{.data} to be correlated with the circumplex scales
and analyzed using correlation-based SSM analyses. To analyze the
circumplex scales using mean-based analyses, simply omit this argument or
set it to NULL (default = NULL).}

\item{grouping}{Optional. The variable name or column number for the variable
in \code{.data} that indicates the group membership of each observation. To
analyze all observations in a single group, simply omit this argument or
set it to NULL (default = NULL).}

\item{contrast}{Optional. A string indicating what type of contrast to run.
Current options are "none" for no contrast, "model" to find SSM parameters
for the difference scores, or "test" to find the difference between the SSM
parameters. Note that only two groups or measures can be contrasted at a
time (default = "none").}

\item{boots}{Optional. A single positive integer indicating how many
bootstrap resamples to use when estimating the confidence intervals
(default = 2000).}

\item{interval}{Optional. A single positive number between 0 and 1
(exclusive) that indicates what confidence level to use when estimating the
confidence intervals (default = 0.95).}

\item{listwise}{Optional. A logical indicating whether missing values should
be handled by listwise deletion (TRUE) or pairwise deletion (FALSE). Note
that pairwise deletion may result in different missing data patterns in
each bootstrap resample and is slower to compute (default = TRUE).}
}
\value{
A list containing the results and description of the analysis.
\item{results}{A tibble with the SSM parameter estimates} \item{details}{A
list with the number of bootstrap resamples (boots), the confidence
interval percentage level (interval), and the angular displacement of
scales (angles)} \item{call}{A language object containing the function call
that created this object} \item{scores}{A tibble containing the mean scale
scores} \item{type}{A string indicating what type of SSM analysis was done}
}
\description{
Calculate SSM parameters with bootstrapped confidence intervals for a variety
of different analysis types. Depending on what arguments are supplied, either
mean-based or correlation-based analyses will be performed, one or more
groups will be used to stratify the data, and contrasts between groups or
measures will be calculated.
}
\examples{
# Load example data
data("jz2017")

# Single-group mean-based SSM
ssm_analyze(jz2017, scales = PA:NO, angles = octants())

# Single-group correlation-based SSM
ssm_analyze(jz2017, scales = PA:NO, angles = octants(), 
  measures = c(NARPD, ASPD))
  
\donttest{
# Multiple-group mean-based SSM
ssm_analyze(jz2017, scales = PA:NO, angles = octants(), grouping = Gender)

# Multiple-group mean-based SSM with contrast
ssm_analyze(jz2017, scales = PA:NO, angles = octants(), grouping = Gender,
  contrast = "model")
  
# Single-group correlation-based SSM with contrast
ssm_analyze(jz2017, scales = PA:NO, angles = octants(),
  measures = c(NARPD, ASPD), contrast = "test")
  
# Multiple-group correlation-based SSM
ssm_analyze(jz2017, scales = PA:NO, angles = octants(), measures = NARPD,
  grouping = Gender)
  
# Multiple-group correlation-based SSM with contrast
ssm_analyze(jz2017, scales = PA:NO, angles = octants(), measures = NARPD,
  grouping = Gender, contrast = "test")
}
}
\seealso{
Other ssm functions: \code{\link{ssm_append}},
  \code{\link{ssm_plot}}, \code{\link{ssm_table}}
}
\concept{analysis functions}
\concept{ssm functions}
