#' Data set in circlizePlus
#'
#' Example can be found in "4.2 Example 2: comparison of two pieces of code that use circlizePlus and circlize to implement the same requirements, respectively"
#' <br><br>allele_frequency: A dataframe with 25,000 rows and 4 columns
#' <br>copy_number: A dataframe with 24,788 rows and 5 columns
#' <br>junctions: A dataframe with 2414 rows and 28 columns
#' <br>r1: A dataframe with 2414 rows and 3 columns
#' <br>r2: A dataframe with 2414 rows and 3 columns
#' @name data-set
#' @source \url{https://www.frontiersin.org/journals/genetics/articles/10.3389/fgene.2025.1535368/full#h5}
#' @examples
#' \donttest{
#' data(example2)
#' allele_frequency
#' copy_number
#' junctions
#' r1
#' r2
#' }
NULL

#' @rdname data-set
#' @usage data(example2)
"allele_frequency"

#' @rdname data-set
#' @usage data(example2)
"copy_number"

#' @rdname data-set
#' @usage data(example2)
"junctions"

#' @rdname data-set
#' @usage data(example2)
"r1"

#' @rdname data-set
#' @usage data(example2)
"r2"
