% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circa_single_mixed.R
\name{circa_single_mixed}
\alias{circa_single_mixed}
\title{circa_single_mixed}
\usage{
circa_single_mixed(
  x,
  col_time,
  col_outcome,
  col_id,
  randomeffects = c("k", "alpha", "phi"),
  period = 24,
  alpha_threshold = 0.05,
  nlme_control = list(),
  nlme_method = "ML",
  verbose = FALSE,
  timeout_n = 10000,
  return_figure = TRUE
)
}
\arguments{
\item{x}{data.frame.  This is the data.frame which contains the rhythmic data in a tidy format.}

\item{col_time}{The name of the column within the data.frame, x, which contains time in hours at which the data were collected.}

\item{col_outcome}{The name of the column within the data.frame, x, which contains outcome measure of interest.}

\item{col_id}{The name of the column within the data.frame, \code{x}, which contains the identifying values for the random effect, such as \code{subject_id}.}

\item{randomeffects}{which rhythmic parameters to allow random effects. The default is to include all rhythmic parameters.}

\item{period}{The period of the rhythm. For circadian rhythms, leave this as the default value, \code{24}.}

\item{alpha_threshold}{The level of alpha for which the presence of rhythmicity is considered. Default is to \code{0.05}.}

\item{nlme_control}{A list of control values for the estimation algorithm to replace the default values returned by the function nlme::nlmeControl. Defaults to an empty list.}

\item{nlme_method}{A character string. If "REML" the model is fit by maximizing the restricted log-likelihood. If "ML" the log-likelihood is maximized. Defaults to "ML".}

\item{verbose}{An optional logical value. If \code{TRUE} information on the evolution of the iterative algorithm is printed. Default is \code{FALSE}.}

\item{timeout_n}{The upper limit for the model fitting attempts. Default is \code{10000}.}

\item{return_figure}{Whether or not to return a ggplot graph of the rhythm and cosine model.}
}
\value{
list
}
\description{
\code{circa_single_mixed} is similar to \code{circa_single} but allows for some simple, user-specified random-effects on the rhythmic parameters of choice.
}
\examples{
set.seed(42)
mixed_data <- function(n){
  counter <- 1
  for(i in 1:n){
      x <- make_data(k1=rnorm(1, 10, 2), alpha1=0, phi1=0)
      x$id <- counter
      counter <- counter + 1
      if(i==1){res <- x}else{res <- rbind(res, x)}
  }
  return(res)
}
df <- mixed_data(n=50)
out <- circa_single_mixed(x = df, col_time = "time", col_outcome = "measure",
                         col_id = "id", randomeffects = c("k"))
}
