% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.r
\name{cimis_to_datetime}
\alias{cimis_to_datetime}
\title{To Datetime}
\usage{
cimis_to_datetime(d)
}
\arguments{
\item{d}{A data frame of CIMIS data results.}
}
\value{
The data frame, with a new \code{"Datetime"} column replacing
the \code{"Date"} and \code{"Hour"} columns.
}
\description{
Collapse The Date and Hour columns to a single DateTime Column.
}
\details{
According to the
\href{https://cimis.water.ca.gov/Default.aspx}{CIMIS Report FAQs},
all CIMIS data is based on Pacific Standard Time (PST).
}
\examples{
if(is_key_set()) {
  d = cimis_data(targets = 170, start.date = Sys.Date() - 4, 
    end.date = Sys.Date() - 1, items = "hly-air-tmp")
  cimis_to_datetime(d)
} 
}
