% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_cifti_from_separate.R
\name{write_cifti_from_separate}
\alias{write_cifti_from_separate}
\title{Write a CIFTI file from NIFTI and GIFTI files}
\usage{
write_cifti_from_separate(
  cifti_fname,
  cortexL_fname = NULL,
  ROIcortexL_fname = NULL,
  cortexR_fname = NULL,
  ROIcortexR_fname = NULL,
  subcortVol_fname = NULL,
  subcortLabs_fname = NULL,
  timestep = NULL,
  timestart = NULL
)
}
\arguments{
\item{cifti_fname}{Path to the CIFTI to write.}

\item{cortexL_fname}{The left cortex file.}

\item{ROIcortexL_fname}{The left cortex ROI file.}

\item{cortexR_fname}{The right cortex file.}

\item{ROIcortexR_fname}{The right cortex ROI file.}

\item{subcortVol_fname}{The subcortical data file.}

\item{subcortLabs_fname}{The subcortical labels file.}

\item{timestep}{If a dense time series ("dtseries.nii") file is being written,
this is the time between measurements. If \code{NULL}, use the Connectome
Workbench default (1.0).}

\item{timestart}{If a dense time series ("dtseries.nii") file is being written,
this is starting time. If \code{NULL}, use the Connectome Workbench default
(0.0).}
}
\description{
Make a CIFTI file from component NIFTI/GIFTI files using the
\code{-cifti-create-...} Connectome Workbench commands.
}
\details{
Every provided component will be included. The ROIs are only used if the
corresponding cortex is provided. Either both or none of the subcortical
NIFTIs should be provided.
}
\keyword{internal}
