% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parc_utils.R
\name{apply_parc}
\alias{apply_parc}
\title{Apply function over locations in each parcel}
\usage{
apply_parc(
  xii,
  parc,
  FUN = mean,
  mwall_value = NA,
  return_as = c("matrix", "xifti"),
  ...
)
}
\arguments{
\item{xii}{The \code{"xifti"} data to apply the function over, within each
parcel.}

\item{parc}{The \code{"xifti"} "dlabel" parcellation. Each parcel is defined
by a unique key in the label table. If there are multiple columns, only the
first column will be used. Alternatively, \code{parc} can just be a vector
of keys whose length is the number of data locations in \code{"xii"}.}

\item{FUN}{A function that takes as input an \eqn{M \times N} matrix (\eqn{M}
locations in a given parcel, and \eqn{N} measurements/columns in \code{xii})
and outputs a constant-sized (\eqn{Q}) numeric vector. Default: \code{mean}.

Use \code{colMeans} to obtain the average timeseries of each parcel, such as
in order to compute functional connectivity.}

\item{mwall_value}{If there is a medial wall in \code{xii}, what should value
should medial wall locations be replaced with prior to calculation?
Default: \code{NA}.}

\item{return_as}{\code{"matrix"} (default) where each row corresponds to a
parcel, or a \code{"xifti"} object where each location's value is the value
of its corresponding parcel?}

\item{...}{Additional arguments to \code{FUN}, e.g. \code{na.rm=TRUE}.
Ignored if \code{FUN=="quick_mean"}.}
}
\value{
A \eqn{P \times Q} matrix, where \eqn{P} is the number of parcels and
\eqn{Q} is the length of the output of \code{FUN}. (For \code{mean},
\eqn{Q = 1}).
}
\description{
Apply a function across all locations in each parcel, for a pair of data and
parcellation \code{"xifti"} objects that are in registration with one
another. By default, the mean value in each parcel is calculated.
}
\seealso{
Other parcellation-related: 
\code{\link{load_parc}()},
\code{\link{load_sub_parc}()},
\code{\link{parc_add_subcortex}()},
\code{\link{parc_borders}()},
\code{\link{parc_vals_to_xifti}()}

Other manipulating xifti: 
\code{\link{add_surf}()},
\code{\link{apply_xifti}()},
\code{\link{combine_xifti}()},
\code{\link{convert_xifti}()},
\code{\link{impute_xifti}()},
\code{\link{merge_xifti}()},
\code{\link{move_to_mwall}()},
\code{\link{move_to_submask}()},
\code{\link{newdata_xifti}()},
\code{\link{remap_cifti}()},
\code{\link{remove_xifti}()},
\code{\link{resample_cifti}()},
\code{\link{resample_cifti_from_template}()},
\code{\link{scale_xifti}()},
\code{\link{select_xifti}()},
\code{\link{set_names_xifti}()},
\code{\link{smooth_cifti}()},
\code{\link{transform_xifti}()}
}
\concept{manipulating xifti}
\concept{parcellation-related}
