% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resample_gifti.R
\name{resample_gifti}
\alias{resample_gifti}
\alias{resampleGIfTI}
\alias{resamplegii}
\title{Resample a GIFTI file (with its ROI)}
\usage{
resample_gifti(
  original_fname,
  target_fname,
  hemisphere = c("left", "right"),
  file_type = NULL,
  original_res = NULL,
  resamp_res = NULL,
  resamp_method = c("barycentric", "adaptive"),
  area_original_fname = NULL,
  area_target_fname = NULL,
  ROIcortex_original_fname = NULL,
  ROIcortex_target_fname = NULL,
  sphere_original_fname = NULL,
  sphere_target_fname = NULL,
  read_dir = NULL,
  write_dir = NULL
)

resampleGIfTI(
  original_fname,
  target_fname,
  hemisphere,
  file_type = NULL,
  original_res = NULL,
  resamp_res,
  ROIcortex_original_fname = NULL,
  ROIcortex_target_fname = NULL,
  read_dir = NULL,
  write_dir = NULL
)

resamplegii(
  original_fname,
  target_fname,
  hemisphere,
  file_type = NULL,
  original_res = NULL,
  resamp_res,
  ROIcortex_original_fname = NULL,
  ROIcortex_target_fname = NULL,
  read_dir = NULL,
  write_dir = NULL
)
}
\arguments{
\item{original_fname}{The GIFTI file to resample.}

\item{target_fname}{Where to save the resampled file.}

\item{hemisphere}{\code{"left"} (default) or \code{"right"}. An error will
occur if the hemisphere indicated in the GIFTI metadata does not match.}

\item{file_type}{\code{"metric"}, \code{"label"}, \code{"surf"}, or \code{NULL}
(default) to infer from \code{original_fname}.}

\item{original_res}{The resolution of the original file. If \code{NULL}
(default), infer from the file. Alternatively, provide
\code{sphere_original_fname} which will override \code{original_res}.

In general, \code{original_res} should be used when the original file is
in registration with the spheres created by the Workbench command
\code{-surface-create-sphere}, and \code{sphere_original_fname} should be
used when it is not compatible.}

\item{resamp_res}{Target resolution for resampling (number of
cortical surface vertices per hemisphere). Alternatively, provide
\code{sphere_target_fname} which will override \code{resamp_res}.

In general, \code{resamp_res} should be used when the target file will be
in registration with the spheres created by the Workbench command
\code{-surface-create-sphere}, and \code{sphere_target_fname} should be
used when it is not compatible.}

\item{resamp_method}{\code{"barycentric"} (default) or \code{"adaptive"}
resampling. These options correspond to the Workbench command options
\code{"BARYCENTRIC"} and \code{"ADAP_BARY_AREA"}, respectively.

While adaptive resampling is recommended for metric or label
data, it requires that \code{area_original_fname} be provided.}

\item{area_original_fname, area_target_fname}{File paths to the surfaces to
use for vertex area correction during adaptive resampling. (Ignored if
resampling with the barycentric method.) \code{area_original_fname} should
match the current resolution of the data, and \code{area_target_fname}
should match \code{resamp_res}. If \code{area_target_fname} is not provided,
\code{area_original_fname} will be resampled with the barycentric method,
and the result will be used as \code{area_target_fname}.}

\item{ROIcortex_original_fname}{The name of the ROI file corresponding to
\code{original_fname}. Leave as \code{NULL} (default) if this doesn't exist
or shouldn't be resampled.}

\item{ROIcortex_target_fname}{The name of the resampled ROI file. Only
applicable if \code{ROIcortex_original_fname} is provided.}

\item{sphere_original_fname, sphere_target_fname}{File paths to the sphere
surfaces in the original and target resolutions. If possible, the simpler
arguments \code{original_res} and \code{resamp_res} can be used instead. But
those depend on the surface being compatible with that created by
\code{-surface-create-sphere}, which isn't always true. Therefore
\code{sphere_original_fname} and \code{sphere_target_fname} can be used if
needed.}

\item{read_dir}{Directory to append to the path of every file name in
\code{original_fname} and \code{ROIcortex_original_fname}. If \code{NULL}
(default), do not append any directory to the path.}

\item{write_dir}{Directory to append to the path of every file name in
\code{target_fname} and \code{ROIcortex_target_fname}. If \code{NULL}
(default), do not append any directory to the path.}
}
\value{
The resampled GIFTI file name, invisibly
}
\description{
Perform spatial resampling of GIFTI data on the cortical surface (metric
and label), or of GIFTI surface geometry data itself.
}
\section{Connectome Workbench}{

This function interfaces with the \code{"-metric-resample"}, \code{"-label-resample"},
and/or \code{"-surface-resample"} Workbench commands, depending on the input.
}

