% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_cifti.R
\name{read_cifti}
\alias{read_cifti}
\alias{readCIFTI}
\alias{readcii}
\title{Read CIFTI File}
\usage{
read_cifti(fname, drop_data = TRUE, trans_data = TRUE)

readCIFTI(fname, drop_data = TRUE, trans_data = TRUE)

readcii(fname, drop_data = TRUE, trans_data = TRUE)
}
\arguments{
\item{fname}{file name of CIFTI file}

\item{drop_data}{Should the empty data dimensions be dropped?}

\item{trans_data}{Should the data be transposed}
}
\value{
List of information from the CIFTI file
}
\description{
Reads CIFTI Files
}
\examples{
if (have_cifti_test_data()) {
   files = download_cifti_data()
   fname = grep("MyelinAndCorrThickness.32k_fs_LR.dscalar",
   files, value = TRUE)
   res = read_cifti(fname)
}
}
