% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RasterArray-raster.R
\name{mask,RasterArray,RasterLayer-method}
\alias{mask,RasterArray,RasterLayer-method}
\alias{mask,RasterArray,RasterArray-method}
\alias{mask,RasterArray,Spatial-method}
\alias{mask,RasterArray,RasterStackBrick-method}
\alias{mask,RasterLayer,RasterArray-method}
\alias{mask,RasterStackBrick,RasterArray-method}
\title{Methods to mask RasterArray objects, or to mask with them}
\usage{
\S4method{mask}{RasterArray,RasterLayer}(
  x,
  mask,
  inverse = FALSE,
  maskvalue = NA,
  updatevalue = NA,
  updateNA = FALSE,
  ...
)

\S4method{mask}{RasterArray,RasterArray}(
  x,
  mask,
  inverse = FALSE,
  maskvalue = NA,
  updatevalue = NA,
  updateNA = FALSE,
  ...
)

\S4method{mask}{RasterArray,Spatial}(x, mask, inverse = FALSE, updatevalue = NA, updateNA = FALSE, ...)

\S4method{mask}{RasterArray,RasterStackBrick}(
  x,
  mask,
  inverse = FALSE,
  maskvalue = NA,
  updatevalue = NA,
  updateNA = FALSE,
  ...
)

\S4method{mask}{RasterLayer,RasterArray}(
  x,
  mask,
  filename = "",
  inverse = FALSE,
  maskvalue = NA,
  updatevalue = NA,
  updateNA = FALSE,
  ...
)

\S4method{mask}{RasterStackBrick,RasterArray}(
  x,
  mask,
  filename = "",
  inverse = FALSE,
  maskvalue = NA,
  updatevalue = NA,
  updateNA = FALSE,
  ...
)
}
\arguments{
\item{x}{Raster* object}

\item{mask}{Raster* object or a Spatial* object}

\item{inverse}{logical. If \code{TRUE}, areas on mask that are _not_ the \code{maskvalue} are masked}

\item{maskvalue}{numeric. The value in \code{mask} that indicates the cells of \code{x} that should become \code{updatevalue (default = NA)}}

\item{updatevalue}{numeric. The value that cells of \code{x} should become if they are not covered by \code{mask} (and not \code{NA})}

\item{updateNA}{logical. If \code{TRUE}, \code{NA} values outside the masked area are also updated to the \code{updatevalue} (only relevant if the \code{updatevalue} is not \code{NA}.}

\item{...}{additional arguments as in \code{\link[raster]{writeRaster}}.}

\item{filename}{character. Optional output filename (only if x is a RasterLayer and RasterStackBrick)}
}
\value{
A \code{RasterArray} or \code{RasterLayer} class object (see detaisl above).
}
\description{
Additional functions to \code{\link[raster]{mask}} generic function involving the \code{\link{RasterArray}} class. The following methods are implemented:
}
\details{
RasterArray masked with RasterLayer: every RasterLayer in the stack masked.


RasterArray masked with another RasterArray: one-to-one match between RasterLayers.


RasterArray masked with RasterStack: one-to-one match between RasterLayers.


RasterArray masked with Spatial: all layers masked with an Sp object


RasterArray masked with Spatial: all layers masked with an Sp object


RasterLayer masked with RasterArray: layer is masked out iteratively with every member of RasterArray.
}
\examples{
data(dems)

# land
lands <- dems
for(i in 1:length(lands)){
  values(lands[i])[values(lands[i])<0] <- NA
  values(lands[i])[!is.na(values(lands[i]))] <- 1
}

# land topographies
landTopo<- mask(dems, lands)

}
