% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_peaks.R
\name{filter_peaktable}
\alias{filter_peaktable}
\title{Filter peak table}
\usage{
filter_peaktable(
  peak_table,
  rts,
  min_rt,
  max_rt,
  min_value,
  comp,
  what = c("median", "mean"),
  tol = 0
)
}
\arguments{
\item{peak_table}{A peak_table object from \code{\link{get_peaktable}}.}

\item{rts}{Vector of retention times to include in the peak table.}

\item{min_rt}{Minimum retention time to include in the peak table.}

\item{max_rt}{Maximum retention time to include in the peak table.}

\item{min_value}{Minimal cutoff for average peak intensity.}

\item{comp}{Component(s) to include in peak table (e.g. wavelengths if you
are using HPLC-DAD/UV).}

\item{what}{Whether to average intensities using \code{mean} or \code{median}.}

\item{tol}{Tolerance for matching of retention times to \code{rts}.}
}
\value{
A peak table similar to the input, with all columns removed
from the peak table that do not satisfy the specified criteria.
}
\description{
Utility function to remove peaks from peak table, e.g. because their
intensity is too low. Currently one can filter on mean or median peak intensity,
or retention time.
}
\examples{
data(pk_tab)
pk_tab <- filter_peaktable(pk_tab, min_rt = 10, max_rt = 16)
}
\seealso{
\code{\link{get_peaktable}}, \code{\link{filter_peaks}}
}
\author{
Ethan Bass
}
