% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attach_metadata.R
\name{attach_ref_spectra}
\alias{attach_ref_spectra}
\title{Attach reference spectra}
\usage{
attach_ref_spectra(peak_table, chrom_list, ref = c("max.cor", "max.int"))
}
\arguments{
\item{peak_table}{Peak table from \code{\link{get_peaktable}}.}

\item{chrom_list}{A list of chromatograms in matrix form (timepoints x
wavelengths).}

\item{ref}{What criterion to use to select reference spectra.
Current options are maximum correlation (\code{max.cor}) or maximum signal
intensity (\code{max.int}).}
}
\value{
A \code{peak_table} object with reference spectra attached in the
\code{$ref_spectra} slot.
}
\description{
Gathers reference spectra and attaches them to peak_table object. Reference 
spectra are defined either as the spectrum with the highest intensity (
\code{max.int}) or as the spectrum with the highest average correlation
to the other spectra in the peak_table (\code{max.cor}).
}
\examples{
data(pk_tab)
pk_tab <- attach_ref_spectra(pk_tab, ref="max.int")
pk_tab <- attach_ref_spectra(pk_tab, ref = "max.cor")
}
\seealso{
\code{\link{get_peaks}} \code{\link{get_peaktable}}
}
\author{
Ethan Bass
}
