% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/euclidean.R
\name{neighborhoodEuclidean}
\alias{neighborhoodEuclidean}
\title{Compute Euclidean path pump neighborhoods.}
\usage{
neighborhoodEuclidean(pump.select = NULL, vestry = FALSE,
  case.location = "nominal", case.set = "observed", multi.core = TRUE,
  dev.mode = FALSE)
}
\arguments{
\item{pump.select}{Numeric. Vector of numeric pump IDs to define pump neighborhoods (i.e., the "population"). Negative selection possible. \code{NULL} selects all pumps.}

\item{vestry}{Logical. \code{TRUE} uses the 14 pumps from the Vestry Report. \code{FALSE} uses the 13 in the original map.}

\item{case.location}{Character. "address" or "nominal". For \code{observed = TRUE}: "address" uses \code{ortho.proj} and "nominal" uses \code{fatalities}. For \code{observed = TRUE}: "address" uses \code{sim.ortho.proj} and "nominal" uses \code{regular.cases}.}

\item{case.set}{Character. "observed" or "expected".}

\item{multi.core}{Logical or Numeric. \code{TRUE} uses \code{parallel::detectCores()}. \code{FALSE} uses one, single core. You can also specify the number logical cores. See \code{vignette("Parallelization")} for details.}

\item{dev.mode}{Logical. Development mode uses parallel::parLapply().}
}
\value{
An R vector.
}
\description{
Plots star graph from pump to its cases.
}
\examples{
\dontrun{
neighborhoodEuclidean()
neighborhoodEuclidean(-6)
neighborhoodEuclidean(pump.select = 6:7)
}
}
