% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segmentLocator.R
\name{segmentLocator}
\alias{segmentLocator}
\title{Locate road segment by its character ID.}
\usage{
segmentLocator(id, zoom = TRUE, radius = 0.5)
}
\arguments{
\item{id}{Character. A concatenation of a street's numeric ID, a whole number between 1 and 528, and a second number to identify the segment.}

\item{zoom}{Logical.}

\item{radius}{Numeric. Controls the degree of zoom. For values <= 5, the anchor case number is plotted.}
}
\value{
A base R graphics plot.
}
\description{
Plots John Snow's map of the 1854 London cholera outbreak and highlights the
selected road segment. With Dodson and Tobler's data, a street (e.g., Broad Street) is often comprised of multiple straight line segments. To identify each segment individually, an additional identifying number is appended to form a text string (e.g., "116-2").
}
\examples{
segmentLocator("190-1")
segmentLocator("216-1")
}
\seealso{
\code{\link{road.segments}}
}
