% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-function.R
\name{chk_function}
\alias{chk_function}
\alias{vld_function}
\title{Check Function}
\usage{
chk_function(x, formals = NULL, x_name = NULL)

vld_function(x, formals = NULL)
}
\arguments{
\item{x}{The object to check.}

\item{formals}{A count of the number of formal arguments.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if is a function using

\code{is.function(x) && (is.null(formals) || length(formals(x)) == formals)}
}
\section{Functions}{
\itemize{
\item \code{vld_function}: Validate Function
}}

\examples{
# chk_function
chk_function(mean)
try(chk_function(1))
# vld_function
vld_function(mean)
vld_function(function(x) x)
vld_function(1)
vld_function(list(1))
}
\seealso{
Other chk_is: 
\code{\link{chk_array}()},
\code{\link{chk_atomic}()},
\code{\link{chk_data}()},
\code{\link{chk_matrix}()},
\code{\link{chk_numeric}()},
\code{\link{chk_s3_class}()},
\code{\link{chk_s4_class}()},
\code{\link{chk_vector}()},
\code{\link{chk_whole_numeric}()}
}
\concept{chk_is}
