#' API Client for CHIRPS and CHIRTS
#'
#' @name chirps
#' @author Kauê de Sousa and Adam H. Sparks and Aniruddha Ghosh
#' @docType package
#' @import methods
#' @note 
#' While \CRANpkg{chirps} does not redistribute the data or provide it in any
#'  way, we encourage users to cite Funk et al. (2015) when using
#'  \acronym{CHIRPS} and Funk et al. (2019) when using \acronym{CHIRTS}.
#' 
#' Funk et al. (2015). Scientific Data, 2, 150066. 
#' \doi{10.1038/sdata.2015.66}
#' 
#' Funk et al. (2019). Journal of Climate, 32(17), 5639–5658. 
#' \doi{10.1175/JCLI-D-18-0698.1}
#' 
#' @seealso
#'\strong{Useful links:}
#' \itemize{
#' \item{JOSS paper: 
#'  \doi{10.21105/joss.02419}}
#' \item{Development repository: 
#'  \url{https://github.com/ropensci/chirps}}
#' \item{Static documentation: 
#'  \url{https://docs.ropensci.org/chirps/}}
#' \item{Report bugs: 
#'  \url{https://github.com/ropensci/chirps/issues}}
#' \item{CHC website: 
#'  \url{https://www.chc.ucsb.edu}}
#' }
"_PACKAGE"
