% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chillR-package.R
\docType{data}
\name{california_stations}
\alias{california_stations}
\title{Weather stations in California}
\format{
a data.frame containing stations from the California UC IPM database
(), with the columns: "Name", "Code", "Interval", "Lat", "Long",
"Elev".  \describe{ \item{list("Name")}{name of the weather station}
\item{list("Code")}{ code of the weather station, indicating the name and
the database it comes from} \item{list("Interval")}{ period of available
data (as character string)} \item{list("Lat")}{ latitude of the station}
\item{list("Long")}{ longitude of the station} \item{list("Elev")}{
elevation of the station} }
}
\source{
UC IPM website: http://www.ipm.ucdavis.edu/WEATHER/index.html
}
\description{
This is a list of weather stations in California that are contained in the
UC IPM database. This can also be generated with
make_california_UCIPM_station_list(), but this takes quite a while. So this
dataset is supposed to be a shortcut to this.
}
\examples{

data(california_stations)

}
\keyword{datasets}
