% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aet01.R
\docType{data}
\name{aet01_main}
\alias{aet01_main}
\alias{aet01_pre}
\alias{aet01_post}
\alias{aet01}
\title{\code{AET01} Table 1 (Default) Overview of Deaths and Adverse Events Summary Table 1.}
\format{
An object of class \code{chevron_t} of length 1.
}
\usage{
aet01_main(
  adam_db,
  arm_var = "ACTARM",
  lbl_overall = NULL,
  anl_vars = list(safety_var = c("FATAL", "SER", "SERWD", "SERDSM", "RELSER", "WD",
    "DSM", "REL", "RELWD", "RELDSM", "SEV")),
  anl_lbls = "Total number of {patient_label} with at least one",
  ...
)

aet01_pre(adam_db, ...)

aet01_post(tlg, prune_0 = FALSE, ...)

aet01
}
\arguments{
\item{adam_db}{(\code{list} of \code{data.frames}) object containing the \code{ADaM} datasets}

\item{arm_var}{(\code{string}) variable used for column splitting}

\item{lbl_overall}{(\code{string}) label used for overall column, if set to \code{NULL} the overall column is omitted}

\item{anl_vars}{Named (\code{list}) of (\code{character}) variables the safety variables to be summarized.}

\item{anl_lbls}{(\code{character}) of analysis labels.}

\item{...}{not used.}

\item{tlg}{(\code{TableTree}, \code{Listing} or \code{ggplot}) object typically produced by a \code{main} function.}

\item{prune_0}{(\code{flag}) remove 0 count rows}
}
\value{
the main function returns an \code{rtables} object.

the preprocessing function returns a \code{list} of \code{data.frame}.

the postprocessing function returns an \code{rtables} object or an \code{ElementaryTable} (null report).
}
\description{
\code{AET01} Table 1 (Default) Overview of Deaths and Adverse Events Summary Table 1.
}
\details{
\itemize{
\item Does not remove rows with zero counts by default.
}
}
\section{Functions}{
\itemize{
\item \code{aet01_main()}: Main TLG function

\item \code{aet01_pre()}: Preprocessing

\item \code{aet01_post()}: Postprocessing

}}
\note{
\itemize{
\item \code{adam_db} object must contain an \code{adsl} table with the \code{"DTHFL"} and \code{"DCSREAS"} columns.
\item \code{adam_db} object must contain an \code{adae} table with the columns passed to \code{anl_vars}.
}
}
\examples{
run(aet01, syn_data, arm_var = "ARM")
}
\keyword{datasets}
