% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/det_order.R
\name{det_order}
\alias{det_order}
\title{Determining reaction order and kinetic formula}
\usage{
det_order(dframe)
}
\arguments{
\item{dframe}{a data-frame with 2 or 3 columns, containing time,
concentrations, and (optional) error data.}
}
\value{
A \code{ord_res} object containing in a list the following information:
\enumerate{
\item the phase space coordinates of transformed data;
\item the linear regression performed in the phase space;
\item a boolean variable indicating if the estimate of the degradation rate
constant is statistically significant;
\item non-linear regression performed using a n^th^-order kinetic model
(if n=0 the regression is linear);
\item the data-frame given as the input;
\item the estimated reaction order.}
}
\description{
The functions seeks to determine the reaction order and kinetic rate
constant for chemical models that best fit degradation kinetic data.
The input of the function is a data-frame organized as follows:
\enumerate{
\item first columns, time data;
\item second columns, concentration data;
\item third column (optional, but highly recommended), experimental error}
}
\examples{
t <- c(0, 4, 8, 12, 16, 20)
conc <- c(1, 0.51, 0.24, 0.12, 0.07, 0.02)
err <- c(0.02, 0.05, 0.04, 0.04, 0.03, 0.02)
dframe <- data.frame(t, conc)
res <- det_order(dframe)

class(res)



dframe2 <- data.frame(t, conc, err)
res2 <- det_order(dframe2)

res2[[5]] == dframe2

}
\seealso{
\code{\link[=results]{results()}} to print the results or \code{\link[=goodness_of_fit]{goodness_of_fit()}} to visualize
the major goodness-of-fit measures; \code{\link[=plot_ord]{plot_ord()}} to plot the regressions in
both the phase and conventional spaces;
\code{\link[=kin_regr]{kin_regr()}} to extract the best kinetic model that explain the data and
\code{\link[=phase_space]{phase_space()}} to extract the linear regression in the phase space.
}
