% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/levels.R
\name{check_levels}
\alias{check_levels}
\title{Check Levels}
\usage{
check_levels(x, levels, exclusive = TRUE, order = TRUE,
  x_name = substitute(x), error = TRUE)
}
\arguments{
\item{x}{The object to check.}

\item{levels}{A character vector of the levels.}

\item{exclusive}{A flag indicating whether other levels are not permitted.}

\item{order}{A flag indicating whether the object levels have to occur in the same order as names. To check whether x is an ordered factor use
\code{check_vector(x, ordered(1))}.}

\item{x_name}{A string of the name of the object.}

\item{error}{A flag indicating whether to throw an informative error or immediately generate an informative message if the check fails.}
}
\value{
An invisible copy of x (if it doesn't throw an error).
}
\description{
Checks the levels in a factor including the order and 
whether other levels are permitted.
}
\examples{
check_levels(1, c("x", "y"), error = FALSE)
check_levels(factor(1), c("x", "y"), error = FALSE)
}
\seealso{
\code{\link{check_nlevels}} and \code{\link{check_vector}}
}
