% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncol.R
\name{check_ncol}
\alias{check_ncol}
\title{Check Number of Columns}
\usage{
check_ncol(x, ncol = TRUE, x_name = substitute(x), error = TRUE)
}
\arguments{
\item{x}{The object to check.}

\item{ncol}{A flag indicating whether x should have columns (versus no columns) or a missing value indicating no requirements or a count or count range of the number of columns.}

\item{x_name}{A string of the name of the object.}

\item{error}{A flag indicating whether to throw an informative error or immediately generate an informative message if the check fails.}
}
\value{
An invisible copy of x (if it doesn't throw an error).
}
\description{
Check Number of Columns
}
\examples{
check_ncol(data.frame(x = 1), error = FALSE)
check_ncol(data.frame(x = 1:2), ncol = 1, error = FALSE)
}
