% Generated by roxygen2 (4.0.1): do not edit by hand
\name{checkMatrix}
\alias{assertMatrix}
\alias{checkMatrix}
\alias{testMatrix}
\title{Check if an argument is a matrix}
\usage{
checkMatrix(x, mode = NULL, any.missing = TRUE, min.rows = NULL,
  min.cols = NULL, nrows = NULL, ncols = NULL, row.names = NULL,
  col.names = NULL)

assertMatrix(x, mode = NULL, any.missing = TRUE, min.rows = NULL,
  min.cols = NULL, nrows = NULL, ncols = NULL, row.names = NULL,
  col.names = NULL, .var.name)

testMatrix(x, mode = NULL, any.missing = TRUE, min.rows = NULL,
  min.cols = NULL, nrows = NULL, ncols = NULL, row.names = NULL,
  col.names = NULL)
}
\arguments{
\item{x}{[ANY]\cr
Object to check.}

\item{.var.name}{[character(1)]\cr
Name for \code{x}. Defaults to a heuristic to determine
the name using \code{\link[base]{deparse}} and \code{\link[base]{substitute}}.}

\item{mode}{[\code{character(1)}]\cr
Storage mode of the matrix. Matricies can hold \dQuote{logical},
\dQuote{integer}, \dQuote{double}, \dQuote{numeric}, \dQuote{complex} and
\dQuote{character}. Default is \code{NULL} (no check).}

\item{any.missing}{[\code{logical(1)}]\cr
Are missing values allowed? Default is \code{TRUE}.}

\item{min.rows}{[\code{integer(1)}]\cr
Minimum number of rows.}

\item{min.cols}{[\code{integer(1)}]\cr
Minimum number of columns.}

\item{nrows}{[\code{integer(1)}]\cr
Exact number of rows.}

\item{ncols}{[\code{integer(1)}]\cr
Exact number of columns.}

\item{row.names}{[\code{character(1)}]\cr
Check for row names. Default is \dQuote{NULL} (no check).
See \code{\link{checkNamed}} for possible values.}

\item{col.names}{[\code{character(1)}]\cr
Check for column names. Default is \dQuote{NULL} (no check).
See \code{\link{checkNamed}} for possible values.}
}
\value{
Depending on the function prefix:
 If the check is successful, all functions return \code{TRUE}.
 If the check is not successful, \code{assertMatrix} throws an error message,
 \code{testMatrix} returns \code{FALSE} and \code{checkMatrix} returns
 a string with the error message.
}
\description{
Check if an argument is a matrix
}
\examples{
x = matrix(1:9, 3)
colnames(x) = letters[1:3]
testMatrix(x, nrows = 3, min.cols = 1, col.names = "named")
}
\seealso{
Other basetypes: \code{\link{assertArray}},
  \code{\link{checkArray}}, \code{\link{testArray}};
  \code{\link{assertAtomicVector}},
  \code{\link{checkAtomicVector}},
  \code{\link{testAtomicVector}};
  \code{\link{assertAtomic}}, \code{\link{checkAtomic}},
  \code{\link{testAtomic}}; \code{\link{assertCharacter}},
  \code{\link{checkCharacter}},
  \code{\link{testCharacter}}; \code{\link{assertComplex}},
  \code{\link{checkComplex}}, \code{\link{testComplex}};
  \code{\link{assertDataFrame}},
  \code{\link{checkDataFrame}},
  \code{\link{testDataFrame}};
  \code{\link{assertEnvironment}},
  \code{\link{checkEnvironment}},
  \code{\link{testEnvironment}};
  \code{\link{assertFactor}}, \code{\link{checkFactor}},
  \code{\link{testFactor}}; \code{\link{assertFunction}},
  \code{\link{checkFunction}}, \code{\link{testFunction}};
  \code{\link{assertIntegerish}},
  \code{\link{checkIntegerish}},
  \code{\link{testIntegerish}};
  \code{\link{assertInteger}}, \code{\link{checkInteger}},
  \code{\link{testInteger}}; \code{\link{assertList}},
  \code{\link{checkList}}, \code{\link{testList}};
  \code{\link{assertLogical}}, \code{\link{checkLogical}},
  \code{\link{testLogical}}; \code{\link{assertNumeric}},
  \code{\link{checkNumeric}}, \code{\link{testNumeric}};
  \code{\link{assertVector}}, \code{\link{checkVector}},
  \code{\link{testVector}}
}

