% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base-provider.R
\name{BareProvider}
\alias{BareProvider}
\title{A NonLocalized Provider that contains all the selection
and creation elements, but not the locales.
That way we can still inherit an do useful stuff
for providers that have no locale.}
\description{
A NonLocalized Provider that contains all the selection
and creation elements, but not the locales.
That way we can still inherit an do useful stuff
for providers that have no locale.

A NonLocalized Provider that contains all the selection
and creation elements, but not the locales.
That way we can still inherit an do useful stuff
for providers that have no locale.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{provider}}{Display the provider name.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-BareProvider-random_element}{\code{BareProvider$random_element()}}
\item \href{#method-BareProvider-random_element_prob}{\code{BareProvider$random_element_prob()}}
\item \href{#method-BareProvider-random_int}{\code{BareProvider$random_int()}}
\item \href{#method-BareProvider-random_digit}{\code{BareProvider$random_digit()}}
\item \href{#method-BareProvider-random_digit_not_zero}{\code{BareProvider$random_digit_not_zero()}}
\item \href{#method-BareProvider-random_digit_or_empty}{\code{BareProvider$random_digit_or_empty()}}
\item \href{#method-BareProvider-random_digit_not_zero_or_empty}{\code{BareProvider$random_digit_not_zero_or_empty()}}
\item \href{#method-BareProvider-random_letter}{\code{BareProvider$random_letter()}}
\item \href{#method-BareProvider-numerify}{\code{BareProvider$numerify()}}
\item \href{#method-BareProvider-lexify}{\code{BareProvider$lexify()}}
\item \href{#method-BareProvider-bothify}{\code{BareProvider$bothify()}}
\item \href{#method-BareProvider-randomize_nb_elements}{\code{BareProvider$randomize_nb_elements()}}
\item \href{#method-BareProvider-print}{\code{BareProvider$print()}}
\item \href{#method-BareProvider-clone}{\code{BareProvider$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BareProvider-random_element"></a>}}
\if{latex}{\out{\hypertarget{method-BareProvider-random_element}{}}}
\subsection{Method \code{random_element()}}{
pick a random element from vector/list
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BareProvider$random_element(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{vector or list}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a single element from x
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BareProvider-random_element_prob"></a>}}
\if{latex}{\out{\hypertarget{method-BareProvider-random_element_prob}{}}}
\subsection{Method \code{random_element_prob()}}{
pick a random element with probability from vector/list
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BareProvider$random_element_prob(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{vector or list}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BareProvider-random_int"></a>}}
\if{latex}{\out{\hypertarget{method-BareProvider-random_int}{}}}
\subsection{Method \code{random_int()}}{
any number of random integers from a min, max
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BareProvider$random_int(min = 0, max = 9999, size = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{min}}{the minimum value. default: 0}

\item{\code{max}}{the maximum value. default: 9999}

\item{\code{size}}{number of values to return. default: 1}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
random integer
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BareProvider-random_digit"></a>}}
\if{latex}{\out{\hypertarget{method-BareProvider-random_digit}{}}}
\subsection{Method \code{random_digit()}}{
random integer between 0 and 9
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BareProvider$random_digit()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BareProvider-random_digit_not_zero"></a>}}
\if{latex}{\out{\hypertarget{method-BareProvider-random_digit_not_zero}{}}}
\subsection{Method \code{random_digit_not_zero()}}{
random integer between 1 and 9
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BareProvider$random_digit_not_zero()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BareProvider-random_digit_or_empty"></a>}}
\if{latex}{\out{\hypertarget{method-BareProvider-random_digit_or_empty}{}}}
\subsection{Method \code{random_digit_or_empty()}}{
random integer between 0 and 9 or empty character string
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BareProvider$random_digit_or_empty()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BareProvider-random_digit_not_zero_or_empty"></a>}}
\if{latex}{\out{\hypertarget{method-BareProvider-random_digit_not_zero_or_empty}{}}}
\subsection{Method \code{random_digit_not_zero_or_empty()}}{
random integer between 1 and 9 or empty character string
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BareProvider$random_digit_not_zero_or_empty()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BareProvider-random_letter"></a>}}
\if{latex}{\out{\hypertarget{method-BareProvider-random_letter}{}}}
\subsection{Method \code{random_letter()}}{
random letter
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BareProvider$random_letter()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BareProvider-numerify"></a>}}
\if{latex}{\out{\hypertarget{method-BareProvider-numerify}{}}}
\subsection{Method \code{numerify()}}{
replace a template with numbers
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BareProvider$numerify(text = "###")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{text}}{(character) a string}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BareProvider-lexify"></a>}}
\if{latex}{\out{\hypertarget{method-BareProvider-lexify}{}}}
\subsection{Method \code{lexify()}}{
replace a template with letters
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BareProvider$lexify(text = "????")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{text}}{(character) a string}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BareProvider-bothify"></a>}}
\if{latex}{\out{\hypertarget{method-BareProvider-bothify}{}}}
\subsection{Method \code{bothify()}}{
both numerify and lexify together
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BareProvider$bothify(text = "## ??")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{text}}{(character) a string}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BareProvider-randomize_nb_elements"></a>}}
\if{latex}{\out{\hypertarget{method-BareProvider-randomize_nb_elements}{}}}
\subsection{Method \code{randomize_nb_elements()}}{
Returns a random value near number
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BareProvider$randomize_nb_elements(
  number = 10,
  le = FALSE,
  ge = FALSE,
  min = NULL,
  max = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{number}}{value to which the result must be near}

\item{\code{le}}{result must be lower or equal to number}

\item{\code{ge}}{result must be greater or equal to number}

\item{\code{min}}{the minimum value. default: \code{NULL}}

\item{\code{max}}{the maximum value. default: \code{NULL}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a random int near number
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BareProvider-print"></a>}}
\if{latex}{\out{\hypertarget{method-BareProvider-print}{}}}
\subsection{Method \code{print()}}{
Print method for provider
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BareProvider$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{ignored by this method}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BareProvider-clone"></a>}}
\if{latex}{\out{\hypertarget{method-BareProvider-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BareProvider$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
