% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internet-provider.R
\docType{data}
\name{InternetProvider}
\alias{InternetProvider}
\alias{internet_provider_locales}
\title{InternetProvider}
\format{An object of class \code{character} of length 8.}
\usage{
internet_provider_locales
}
\arguments{
\item{locale}{(character) the locale to use. Run
\code{internet_provider_locales()} for locales supported (default: en_US)}
}
\description{
InternetProvider
}
\details{
\strong{Methods}
\itemize{
\item \code{to_ascii(x)} - convert to ascii
\item \code{email(domain)} - get an email address
\item \code{safe_email()} - get a safe email address
\item \code{free_email()} - free email address
\item \code{company_email()} - company email address
\item \code{ascii_email()} - ascii email address
\item \code{ascii_safe_email()} - safe ascii email address
\item \code{ascii_free_email()} - an ascii free email address
\item \code{ascii_company_email()} - ascii company email address
\item \code{user_name()} - a user name
\item \code{tld()} - a tld
\item \code{free_email_domain()} - free email domain
\item \code{url(schemes)} - get a url
\item \code{domain_name(levels)} - get a domain name
\item \code{domain_word()} - get a domain word
\item \code{ipv4()} - get a random ipv4 address
\item \code{mac_address()} - get a mac address
\item \code{uri_page()} - get a uri page
\item \code{uri_path()} - get a uri path
\item \code{uri_extension()} - get a uri extension
\item \code{image_url(width, height)} - get an image url
}
}
\note{
Note that if a locale you set doesn't have a locale specific set
of data for \link{PersonProvider} or \link{CompanyProvider} we fall back to
\code{en_US}
}
\examples{
(x <- InternetProvider$new())
x$locale

# uri/url/tld/etc.
x$tld()
x$domain_word()
x$domain_name()
x$domain_name(levels = 2)
x$domain_name(levels = 3)
x$domain_name(levels = 10)
## url's
x$url()
x$url(schemes = c('hbbp', 'hggp'))
x$image_url()
## uri's
x$uri()
x$uri_page()
x$uri_extension()
x$uri_path()
x$uri_path(deep = 1)
x$uri_path(deep = 2)
x$uri_path(deep = 3)
x$uri_path(deep = 4)

# user name
x$user_name()

# emails
x$email()
x$safe_email()
x$free_email()
x$company_email()
x$free_email_domain()
x$ascii_email()
x$ascii_safe_email()
x$ascii_free_email()
x$ascii_company_email()

# addresses, mac, ipv4
x$mac_address()
x$ipv4()

# different locales
(x <- InternetProvider$new(locale = "en_AU"))
x$locale
x$tld()
x$email()
x$free_email_domain()

(x <- InternetProvider$new(locale = "de_DE"))
x$locale
x$tld()
x$uri()
x$email()
x$ascii_email()

(x <- InternetProvider$new(locale = "bg_BG"))
x$locale
x$tld()
x$uri()
x$url()
x$user_name()
x$email()
x$ascii_email()

(x <- InternetProvider$new(locale = "cs_CZ"))
x$url()
x$user_name()
x$email()

(x <- InternetProvider$new(locale = "fa_IR"))
x$url()

(x <- InternetProvider$new(locale = "fr_FR"))
x$url()
x$user_name()
x$email()

(x <- InternetProvider$new(locale = "hr_HR"))
x$url()
x$user_name()
x$email()
}
\keyword{datasets}
\keyword{internal}
