% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HD_regression.R
\name{simu.change.regression}
\alias{simu.change.regression}
\title{Simulate a sparse regression model with change points in coefficients.}
\usage{
simu.change.regression(d0, cpt_true, p, n, sigma, kappa)
}
\arguments{
\item{d0}{A \code{numeric} scalar of number of nonzero coefficients.}

\item{cpt_true}{An \code{integer} vector of true change points (sorted in strictly increasing order).}

\item{p}{An \code{integer} scalar of dimensionality.}

\item{n}{An \code{integer} scalar of sample size.}

\item{sigma}{A \code{numeric} scalar of error standard deviation.}

\item{kappa}{A \code{numeric} scalar of minimum jump size of coefficient vector in terms of \eqn{l_2} norm.}
}
\value{
A \code{list} with the following structure:
 \item{cpt_true}{A vector of true changepoints (sorted in strictly increasing order).}
 \item{X}{A p-by-n design matrix.}
 \item{y}{A n-dim vector of response variable.}
 \item{betafullmat}{A p-by-n matrix of coefficients.}
}
\description{
Simulate a sparse regression model with change points in coefficients under the setting of Simulations 4.2 in Rinaldo et al. (2021).
}
\examples{
d0 = 10
p = 30
n = 100
cpt_true = c(10, 30, 40, 70, 90)
data = simu.change.regression(d0, cpt_true, p, n, sigma = 1, kappa = 9)
}
\references{
Rinaldo, Wang, Wen, Willett and Yu (2020) <arxiv:2010.10410>.
}
\author{
Daren Wang & Haotian Xu
}
