% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/changepoint.mv.class.R
\docType{methods}
\name{cpts.mr}
\alias{cpts.mr}
\alias{cpts.mr,changepoint.mv.mrc.class-method}
\title{Most recent changepoint locations.}
\usage{
\S4method{cpts.mr}{changepoint.mv.mrc.class}(x, p = x@pmax)
}
\arguments{
\item{x}{An S4 object as returned by \code{\link{mrc}}.}

\item{p}{The number of most recent changepoints locations to be considered. Default value is \code{p=x@pmax} where pmax
is the value specified when \code{\link{mrc}} was called.}
}
\value{
A data frame containing the most recent changepoint locations and the the variates corresponding to those locations.
}
\description{
Returns a list of vectors containing the most recent changepoint locations.
}
\examples{
library(changepoint.mv)
data(mrcexample)
res<-mrc(mrcexample)
cpts.mr(res)
cpts.mr(res,p=2)

}
