% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chandwich.R
\docType{package}
\name{chandwich}
\alias{chandwich}
\alias{chandwich-package}
\title{chandwich: Chandler-Bate Sandwich Loglikelihood Adjustment}
\description{
Performs adjustments of an independence loglikelihood using
a robust sandwich estimator of the parameter covariance matrix, based on
the methodology in
\href{http://dx.doi.org/10.1093/biomet/asm015}{Chandler and Bate (2007)}.
This can be used for cluster correlated data when interest lies in the
parameters of the marginal distributions.
Functions for profiling the adjusted loglikelihoods are also provided, as
are functions for calculating and plotting confidence intervals, for single
model parameters, and confidence regions, for pairs of model parameters.
}
\details{
The main function in the chandwich package is \code{adjust_loglik}.  It
finds the maximum likelihood estimate (MLE) of model parameters based on
an independence loglikelihood in which cluster dependence in the data is
ignored.  The independence loglikelihood is adjusted in a way that ensures
that the Hessian of the adjusted loglikelihood coincides with a robust
sandwich estimate of the parameter covariance at the MLE.  Three
adjustments are available: one in which the independence loglikelihood
itself is scaled (vertical scaling) and two others where the scaling
is in the parameter vector (horizontal scaling).

See Chandler and Bate (2007) for full details and
\code{vignette("chandwich-vignette", package = "chandwich")} for an
overview of the package.
}
\references{
Chandler, R. E. and Bate, S. (2007). Inference for clustered
  data using the independence loglikelihood. \emph{Biometrika},
  \strong{94}(1), 167-183. \url{http://dx.doi.org/10.1093/biomet/asm015}
}
\seealso{
\code{\link{adjust_loglik}} to adjust a user-supplied
  loglikelihood.

\code{\link{compare_models}} to compare nested models using an
  adjusted loglikelihood ratio test.  See also the S3 method
  \code{\link{anova.chandwich}}.

\code{\link{conf_intervals}} to calculate confidence intervals
  for individual model parameters.  See also the S3 method
  \code{\link{confint.chandwich}}.

\code{\link{conf_region}} to calculate a confidence region
  for a pair of model parameters.
}
