full_race_names  <- list(
  white = 'White',
  black = 'Black or African American',
  hisp = 'Hispanic or Latino',
  aian = 'American Indian and Alaska Native',
  asian = 'Asian',
  nhpi = 'Native Hawaiian and Other Pacific Islander',
  other = 'Some Other Race'
)

#fetch_api_vars_ap_legacy <- function(year, group, race) {
# group <- dplyr::case_when(
#   year == 2020 & group == 'pop' ~ 'P1',
#   year == 2020 & group == 'vap' ~ 'P3',
#   year == 2010 & group == 'pop' ~ 'P001',
#   year == 2010 & group == 'vap' ~ 'P003',
#   year == 2000 & group == 'pop' ~ 'PL001',
#   year == 2000 & group == 'vap' ~ 'PL003',
#   TRUE ~ NA_character_
# )
# tidycensus::load_variables(year, dataset = 'pl') %>%
#   dplyr::filter(stringr::str_detect(.data$label, paste0('(?i)', full_race_names[race]))) %>%
#   dplyr::filter(startsWith(.data$name, group)) %>%
#   dplyr::pull(.data$name)
# }
# api_vars_ap <- tidyr::expand_grid(
#   year = c(2020, 2010, 2000), group = c('pop', 'vap'),
#   race = setdiff(names(full_race_names), 'hisp')
# ) %>%
#   dplyr::rowwise() %>%
#   dplyr::mutate(
#     vars = list(fetch_api_vars_ap_legacy(year, group, race))
#     ) %>%
#   dplyr::ungroup() %>%
#   datapasta::tribble_paste()
api_vars_ap <- tibble::tribble(
  ~year, ~group,   ~race,                                                                                                                                                                                                                                                                                                                                                                                             ~vars,
   2020,  "pop", "white",                                 c("P1_003N", "P1_011N", "P1_012N", "P1_013N", "P1_014N", "P1_015N", "P1_027N", "P1_028N", "P1_029N", "P1_030N", "P1_031N", "P1_032N", "P1_033N", "P1_034N", "P1_035N", "P1_036N", "P1_048N", "P1_049N", "P1_050N", "P1_051N", "P1_052N", "P1_053N", "P1_054N", "P1_055N", "P1_056N", "P1_057N", "P1_064N", "P1_065N", "P1_066N", "P1_067N", "P1_068N", "P1_071N"),
   2020,  "pop", "black",                                 c("P1_004N", "P1_011N", "P1_016N", "P1_017N", "P1_018N", "P1_019N", "P1_027N", "P1_028N", "P1_029N", "P1_030N", "P1_037N", "P1_038N", "P1_039N", "P1_040N", "P1_041N", "P1_042N", "P1_048N", "P1_049N", "P1_050N", "P1_051N", "P1_052N", "P1_053N", "P1_058N", "P1_059N", "P1_060N", "P1_061N", "P1_064N", "P1_065N", "P1_066N", "P1_067N", "P1_069N", "P1_071N"),
   2020,  "pop",  "aian",                                 c("P1_005N", "P1_012N", "P1_016N", "P1_020N", "P1_021N", "P1_022N", "P1_027N", "P1_031N", "P1_032N", "P1_033N", "P1_037N", "P1_038N", "P1_039N", "P1_043N", "P1_044N", "P1_045N", "P1_048N", "P1_049N", "P1_050N", "P1_054N", "P1_055N", "P1_056N", "P1_058N", "P1_059N", "P1_060N", "P1_062N", "P1_064N", "P1_065N", "P1_066N", "P1_068N", "P1_069N", "P1_071N"),
   2020,  "pop", "asian",                                 c("P1_006N", "P1_013N", "P1_017N", "P1_020N", "P1_023N", "P1_024N", "P1_028N", "P1_031N", "P1_034N", "P1_035N", "P1_037N", "P1_040N", "P1_041N", "P1_043N", "P1_044N", "P1_046N", "P1_048N", "P1_051N", "P1_052N", "P1_054N", "P1_055N", "P1_057N", "P1_058N", "P1_059N", "P1_061N", "P1_062N", "P1_064N", "P1_065N", "P1_067N", "P1_068N", "P1_069N", "P1_071N"),
   2020,  "pop",  "nhpi",                                 c("P1_007N", "P1_014N", "P1_018N", "P1_021N", "P1_023N", "P1_025N", "P1_029N", "P1_032N", "P1_034N", "P1_036N", "P1_038N", "P1_040N", "P1_042N", "P1_043N", "P1_045N", "P1_046N", "P1_049N", "P1_051N", "P1_053N", "P1_054N", "P1_056N", "P1_057N", "P1_058N", "P1_060N", "P1_061N", "P1_062N", "P1_064N", "P1_066N", "P1_067N", "P1_068N", "P1_069N", "P1_071N"),
   2020,  "pop", "other",                                 c("P1_008N", "P1_015N", "P1_019N", "P1_022N", "P1_024N", "P1_025N", "P1_030N", "P1_033N", "P1_035N", "P1_036N", "P1_039N", "P1_041N", "P1_042N", "P1_044N", "P1_045N", "P1_046N", "P1_050N", "P1_052N", "P1_053N", "P1_055N", "P1_056N", "P1_057N", "P1_059N", "P1_060N", "P1_061N", "P1_062N", "P1_065N", "P1_066N", "P1_067N", "P1_068N", "P1_069N", "P1_071N"),
   2020,  "vap", "white",                                 c("P3_003N", "P3_011N", "P3_012N", "P3_013N", "P3_014N", "P3_015N", "P3_027N", "P3_028N", "P3_029N", "P3_030N", "P3_031N", "P3_032N", "P3_033N", "P3_034N", "P3_035N", "P3_036N", "P3_048N", "P3_049N", "P3_050N", "P3_051N", "P3_052N", "P3_053N", "P3_054N", "P3_055N", "P3_056N", "P3_057N", "P3_064N", "P3_065N", "P3_066N", "P3_067N", "P3_068N", "P3_071N"),
   2020,  "vap", "black",                                 c("P3_004N", "P3_011N", "P3_016N", "P3_017N", "P3_018N", "P3_019N", "P3_027N", "P3_028N", "P3_029N", "P3_030N", "P3_037N", "P3_038N", "P3_039N", "P3_040N", "P3_041N", "P3_042N", "P3_048N", "P3_049N", "P3_050N", "P3_051N", "P3_052N", "P3_053N", "P3_058N", "P3_059N", "P3_060N", "P3_061N", "P3_064N", "P3_065N", "P3_066N", "P3_067N", "P3_069N", "P3_071N"),
   2020,  "vap",  "aian",                                 c("P3_005N", "P3_012N", "P3_016N", "P3_020N", "P3_021N", "P3_022N", "P3_027N", "P3_031N", "P3_032N", "P3_033N", "P3_037N", "P3_038N", "P3_039N", "P3_043N", "P3_044N", "P3_045N", "P3_048N", "P3_049N", "P3_050N", "P3_054N", "P3_055N", "P3_056N", "P3_058N", "P3_059N", "P3_060N", "P3_062N", "P3_064N", "P3_065N", "P3_066N", "P3_068N", "P3_069N", "P3_071N"),
   2020,  "vap", "asian",                                 c("P3_006N", "P3_013N", "P3_017N", "P3_020N", "P3_023N", "P3_024N", "P3_028N", "P3_031N", "P3_034N", "P3_035N", "P3_037N", "P3_040N", "P3_041N", "P3_043N", "P3_044N", "P3_046N", "P3_048N", "P3_051N", "P3_052N", "P3_054N", "P3_055N", "P3_057N", "P3_058N", "P3_059N", "P3_061N", "P3_062N", "P3_064N", "P3_065N", "P3_067N", "P3_068N", "P3_069N", "P3_071N"),
   2020,  "vap",  "nhpi",                                 c("P3_007N", "P3_014N", "P3_018N", "P3_021N", "P3_023N", "P3_025N", "P3_029N", "P3_032N", "P3_034N", "P3_036N", "P3_038N", "P3_040N", "P3_042N", "P3_043N", "P3_045N", "P3_046N", "P3_049N", "P3_051N", "P3_053N", "P3_054N", "P3_056N", "P3_057N", "P3_058N", "P3_060N", "P3_061N", "P3_062N", "P3_064N", "P3_066N", "P3_067N", "P3_068N", "P3_069N", "P3_071N"),
   2020,  "vap", "other",                                 c("P3_008N", "P3_015N", "P3_019N", "P3_022N", "P3_024N", "P3_025N", "P3_030N", "P3_033N", "P3_035N", "P3_036N", "P3_039N", "P3_041N", "P3_042N", "P3_044N", "P3_045N", "P3_046N", "P3_050N", "P3_052N", "P3_053N", "P3_055N", "P3_056N", "P3_057N", "P3_059N", "P3_060N", "P3_061N", "P3_062N", "P3_065N", "P3_066N", "P3_067N", "P3_068N", "P3_069N", "P3_071N"),
   2010,  "pop", "white",                                 c("P001003", "P001011", "P001012", "P001013", "P001014", "P001015", "P001027", "P001028", "P001029", "P001030", "P001031", "P001032", "P001033", "P001034", "P001035", "P001036", "P001048", "P001049", "P001050", "P001051", "P001052", "P001053", "P001054", "P001055", "P001056", "P001057", "P001064", "P001065", "P001066", "P001067", "P001068", "P001071"),
   2010,  "pop", "black",                                 c("P001004", "P001011", "P001016", "P001017", "P001018", "P001019", "P001027", "P001028", "P001029", "P001030", "P001037", "P001038", "P001039", "P001040", "P001041", "P001042", "P001048", "P001049", "P001050", "P001051", "P001052", "P001053", "P001058", "P001059", "P001060", "P001061", "P001064", "P001065", "P001066", "P001067", "P001069", "P001071"),
   2010,  "pop",  "aian",                                 c("P001005", "P001012", "P001016", "P001020", "P001021", "P001022", "P001027", "P001031", "P001032", "P001033", "P001037", "P001038", "P001039", "P001043", "P001044", "P001045", "P001048", "P001049", "P001050", "P001054", "P001055", "P001056", "P001058", "P001059", "P001060", "P001062", "P001064", "P001065", "P001066", "P001068", "P001069", "P001071"),
   2010,  "pop", "asian",                                 c("P001006", "P001013", "P001017", "P001020", "P001023", "P001024", "P001028", "P001031", "P001034", "P001035", "P001037", "P001040", "P001041", "P001043", "P001044", "P001046", "P001048", "P001051", "P001052", "P001054", "P001055", "P001057", "P001058", "P001059", "P001061", "P001062", "P001064", "P001065", "P001067", "P001068", "P001069", "P001071"),
   2010,  "pop",  "nhpi",                                 c("P001007", "P001014", "P001018", "P001021", "P001023", "P001025", "P001029", "P001032", "P001034", "P001036", "P001038", "P001040", "P001042", "P001043", "P001045", "P001046", "P001049", "P001051", "P001053", "P001054", "P001056", "P001057", "P001058", "P001060", "P001061", "P001062", "P001064", "P001066", "P001067", "P001068", "P001069", "P001071"),
   2010,  "pop", "other",                                 c("P001008", "P001015", "P001019", "P001022", "P001024", "P001025", "P001030", "P001033", "P001035", "P001036", "P001039", "P001041", "P001042", "P001044", "P001045", "P001046", "P001050", "P001052", "P001053", "P001055", "P001056", "P001057", "P001059", "P001060", "P001061", "P001062", "P001065", "P001066", "P001067", "P001068", "P001069", "P001071"),
   2010,  "vap", "white",                                 c("P003003", "P003011", "P003012", "P003013", "P003014", "P003015", "P003027", "P003028", "P003029", "P003030", "P003031", "P003032", "P003033", "P003034", "P003035", "P003036", "P003048", "P003049", "P003050", "P003051", "P003052", "P003053", "P003054", "P003055", "P003056", "P003057", "P003064", "P003065", "P003066", "P003067", "P003068", "P003071"),
   2010,  "vap", "black",                                 c("P003004", "P003011", "P003016", "P003017", "P003018", "P003019", "P003027", "P003028", "P003029", "P003030", "P003037", "P003038", "P003039", "P003040", "P003041", "P003042", "P003048", "P003049", "P003050", "P003051", "P003052", "P003053", "P003058", "P003059", "P003060", "P003061", "P003064", "P003065", "P003066", "P003067", "P003069", "P003071"),
   2010,  "vap",  "aian",                                 c("P003005", "P003012", "P003016", "P003020", "P003021", "P003022", "P003027", "P003031", "P003032", "P003033", "P003037", "P003038", "P003039", "P003043", "P003044", "P003045", "P003048", "P003049", "P003050", "P003054", "P003055", "P003056", "P003058", "P003059", "P003060", "P003062", "P003064", "P003065", "P003066", "P003068", "P003069", "P003071"),
   2010,  "vap", "asian",                                 c("P003006", "P003013", "P003017", "P003020", "P003023", "P003024", "P003028", "P003031", "P003034", "P003035", "P003037", "P003040", "P003041", "P003043", "P003044", "P003046", "P003048", "P003051", "P003052", "P003054", "P003055", "P003057", "P003058", "P003059", "P003061", "P003062", "P003064", "P003065", "P003067", "P003068", "P003069", "P003071"),
   2010,  "vap",  "nhpi",                                 c("P003007", "P003014", "P003018", "P003021", "P003023", "P003025", "P003029", "P003032", "P003034", "P003036", "P003038", "P003040", "P003042", "P003043", "P003045", "P003046", "P003049", "P003051", "P003053", "P003054", "P003056", "P003057", "P003058", "P003060", "P003061", "P003062", "P003064", "P003066", "P003067", "P003068", "P003069", "P003071"),
   2010,  "vap", "other",                                 c("P003008", "P003015", "P003019", "P003022", "P003024", "P003025", "P003030", "P003033", "P003035", "P003036", "P003039", "P003041", "P003042", "P003044", "P003045", "P003046", "P003050", "P003052", "P003053", "P003055", "P003056", "P003057", "P003059", "P003060", "P003061", "P003062", "P003065", "P003066", "P003067", "P003068", "P003069", "P003071"),
   2000,  "pop", "white", c("PL001003", "PL001011", "PL001012", "PL001013", "PL001014", "PL001015", "PL001027", "PL001028", "PL001029", "PL001030", "PL001031", "PL001032", "PL001033", "PL001034", "PL001035", "PL001036", "PL001048", "PL001049", "PL001050", "PL001051", "PL001052", "PL001053", "PL001054", "PL001055", "PL001056", "PL001057", "PL001064", "PL001065", "PL001066", "PL001067", "PL001068", "PL001071"),
   2000,  "pop", "black", c("PL001004", "PL001011", "PL001016", "PL001017", "PL001018", "PL001019", "PL001027", "PL001028", "PL001029", "PL001030", "PL001037", "PL001038", "PL001039", "PL001040", "PL001041", "PL001042", "PL001048", "PL001049", "PL001050", "PL001051", "PL001052", "PL001053", "PL001058", "PL001059", "PL001060", "PL001061", "PL001064", "PL001065", "PL001066", "PL001067", "PL001069", "PL001071"),
   2000,  "pop",  "aian", c("PL001005", "PL001012", "PL001016", "PL001020", "PL001021", "PL001022", "PL001027", "PL001031", "PL001032", "PL001033", "PL001037", "PL001038", "PL001039", "PL001043", "PL001044", "PL001045", "PL001048", "PL001049", "PL001050", "PL001054", "PL001055", "PL001056", "PL001058", "PL001059", "PL001060", "PL001062", "PL001064", "PL001065", "PL001066", "PL001068", "PL001069", "PL001071"),
   2000,  "pop", "asian", c("PL001006", "PL001013", "PL001017", "PL001020", "PL001023", "PL001024", "PL001028", "PL001031", "PL001034", "PL001035", "PL001037", "PL001040", "PL001041", "PL001043", "PL001044", "PL001046", "PL001048", "PL001051", "PL001052", "PL001054", "PL001055", "PL001057", "PL001058", "PL001059", "PL001061", "PL001062", "PL001064", "PL001065", "PL001067", "PL001068", "PL001069", "PL001071"),
   2000,  "pop",  "nhpi", c("PL001007", "PL001014", "PL001018", "PL001021", "PL001023", "PL001025", "PL001029", "PL001032", "PL001034", "PL001036", "PL001038", "PL001040", "PL001042", "PL001043", "PL001045", "PL001046", "PL001049", "PL001051", "PL001053", "PL001054", "PL001056", "PL001057", "PL001058", "PL001060", "PL001061", "PL001062", "PL001064", "PL001066", "PL001067", "PL001068", "PL001069", "PL001071"),
   2000,  "pop", "other", c("PL001008", "PL001015", "PL001019", "PL001022", "PL001024", "PL001025", "PL001030", "PL001033", "PL001035", "PL001036", "PL001039", "PL001041", "PL001042", "PL001044", "PL001045", "PL001046", "PL001050", "PL001052", "PL001053", "PL001055", "PL001056", "PL001057", "PL001059", "PL001060", "PL001061", "PL001062", "PL001065", "PL001066", "PL001067", "PL001068", "PL001069", "PL001071"),
   2000,  "vap", "white", c("PL003003", "PL003011", "PL003012", "PL003013", "PL003014", "PL003015", "PL003027", "PL003028", "PL003029", "PL003030", "PL003031", "PL003032", "PL003033", "PL003034", "PL003035", "PL003036", "PL003048", "PL003049", "PL003050", "PL003051", "PL003052", "PL003053", "PL003054", "PL003055", "PL003056", "PL003057", "PL003064", "PL003065", "PL003066", "PL003067", "PL003068", "PL003071"),
   2000,  "vap", "black", c("PL003004", "PL003011", "PL003016", "PL003017", "PL003018", "PL003019", "PL003027", "PL003028", "PL003029", "PL003030", "PL003037", "PL003038", "PL003039", "PL003040", "PL003041", "PL003042", "PL003048", "PL003049", "PL003050", "PL003051", "PL003052", "PL003053", "PL003058", "PL003059", "PL003060", "PL003061", "PL003064", "PL003065", "PL003066", "PL003067", "PL003069", "PL003071"),
   2000,  "vap",  "aian", c("PL003005", "PL003012", "PL003016", "PL003020", "PL003021", "PL003022", "PL003027", "PL003031", "PL003032", "PL003033", "PL003037", "PL003038", "PL003039", "PL003043", "PL003044", "PL003045", "PL003048", "PL003049", "PL003050", "PL003054", "PL003055", "PL003056", "PL003058", "PL003059", "PL003060", "PL003062", "PL003064", "PL003065", "PL003066", "PL003068", "PL003069", "PL003071"),
   2000,  "vap", "asian", c("PL003006", "PL003013", "PL003017", "PL003020", "PL003023", "PL003024", "PL003028", "PL003031", "PL003034", "PL003035", "PL003037", "PL003040", "PL003041", "PL003043", "PL003044", "PL003046", "PL003048", "PL003051", "PL003052", "PL003054", "PL003055", "PL003057", "PL003058", "PL003059", "PL003061", "PL003062", "PL003064", "PL003065", "PL003067", "PL003068", "PL003069", "PL003071"),
   2000,  "vap",  "nhpi", c("PL003007", "PL003014", "PL003018", "PL003021", "PL003023", "PL003025", "PL003029", "PL003032", "PL003034", "PL003036", "PL003038", "PL003040", "PL003042", "PL003043", "PL003045", "PL003046", "PL003049", "PL003051", "PL003053", "PL003054", "PL003056", "PL003057", "PL003058", "PL003060", "PL003061", "PL003062", "PL003064", "PL003066", "PL003067", "PL003068", "PL003069", "PL003071"),
   2000,  "vap", "other", c("PL003008", "PL003015", "PL003019", "PL003022", "PL003024", "PL003025", "PL003030", "PL003033", "PL003035", "PL003036", "PL003039", "PL003041", "PL003042", "PL003044", "PL003045", "PL003046", "PL003050", "PL003052", "PL003053", "PL003055", "PL003056", "PL003057", "PL003059", "PL003060", "PL003061", "PL003062", "PL003065", "PL003066", "PL003067", "PL003068", "PL003069", "PL003071")
  )
