% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_pa.r
\name{get_pa}
\alias{get_pa}
\title{Retrieve Protected Area Information}
\usage{
get_pa(ea_name = NULL, column = NULL)
}
\arguments{
\item{ea_name}{A string representing the description (\code{name} for 
\code{OC}, \code{MC} or \code{RBD} level downloads or \code{WBID} for 
individual waterbodies) of the features to be extracted. For example 
to extract data for the whole of the Humber RBD, this would be "Humber"; 
also see examples. Must be an exact match to the values used in the 
EA database. Use the \code{\link{search_names}} function to search 
for specific values.}

\item{column}{The column to be searched. Possible options are
\code{WBID} (waterbody id), \code{OC} (Operational Catchment), \code{MC}
(Management Catchment) and \code{RBD} (River Basin District)}
}
\value{
An object of class \code{cde_df} containing the details of the 
Protected Areas associated with the waterbodies.
For details of the meaning of the the different columns returned, 
see \url{https://docs.ropensci.org/cde/articles/cde-output-reference.html}.
}
\description{
Retrieves details of Protected Areas associated with 
waterbodies, catchments or River Basin Districts from the EA 
Catchment Data Explorer site.
Data can be retrieved by specifying waterbody id
(\code{WBID}), Management Catchment (\code{MC}), Operational
Catchment (\code{OC}) or River Basin District (\code{RBD}).
}
\examples{
# get protected areas associated with waterbody GB112071065700
get_pa(ea_name="GB112071065700", column="WBID")

# get the protected areas associated with the Humber RBD
get_pa(ea_name="Humber", column="RBD")

# get the protected areas associated with the Avon Warwickshire
# Management Catchment
get_pa(ea_name="Avon Warwickshire", column="MC")

}
