% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opspec.R
\name{blocks_to_rowrecs_spec}
\alias{blocks_to_rowrecs_spec}
\title{Create a block records to row records transform specification.}
\usage{
blocks_to_rowrecs_spec(controlTable, ..., recordKeys = character(0),
  controlTableKeys = colnames(controlTable)[[1]], checkNames = TRUE,
  checkKeys = TRUE, strict = FALSE, allow_rqdatatable = FALSE)
}
\arguments{
\item{controlTable}{an all character data frame or cdata pivot control.}

\item{...}{not used, force later arguments to bind by name.}

\item{recordKeys}{vector of columns identifying records.}

\item{controlTableKeys}{vector of keying columns of the controlTable.}

\item{checkNames}{passed to blocks_to_rowrecs.}

\item{checkKeys}{passed to blocks_to_rowrecs.}

\item{strict}{passed to blocks_to_rowrecs.}

\item{allow_rqdatatable}{logical, if TRUE allow rqdatatable shortcutting on simple conversions.}
}
\value{
a record specification object
}
\description{
Create a block records to row records transform specification object that holds the pivot control table, specification of
extra row keys, and control table keys.
}
\examples{

d <- wrapr::build_frame(
  "id", "measure", "value" |
  1   , "AUC"    , 0.7     |
  1   , "R2"     , 0.4     |
  2   , "AUC"    , 0.8     |
  2   , "R2"     , 0.5     )

transform <- blocks_to_rowrecs_spec(
  wrapr::qchar_frame(
    "measure", "value" |
    "AUC"    , AUC     |
    "R2"     , R2      ),
  recordKeys = "id")

print(transform)

d \%.>\% transform

inv_transform <- t(transform)
print(inv_transform)

# identity (in structure)
d \%.>\% transform \%.>\% inv_transform

# identity again (using .() "immediate" notation)
d \%.>\% transform \%.>\% .(t(transform))


}
