% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfa.R
\name{test.lige}
\alias{test.lige}
\title{test.lige}
\usage{
test.lige(cfaobj, allt, se = T, h)
}
\arguments{
\item{cfaobj}{a CFA object}

\item{allt}{all the values of the treatment variable in the dataset}

\item{se}{boolean whether or not to compute standard errors}

\item{h}{a bandwidth}
}
\value{
a CFASE object
}
\description{
test if the local intergnerational elasticity is the same across
 all values of the treatment variable
}
\examples{
\dontrun{
data(igm)
tvals <- seq(10,12,length.out=8)
yvals <- seq(quantile(igm$lcfincome, .05), quantile(igm$lcfincome, .95), length.out=50)

## obtain counterfactual results
out <- cfa2(lcfincome ~ lfincome, tvals, yvals, igm, method1="qr",
xformla2=~HEDUC, method2="qr", iters=10, tau1=seq(.05,.95,.05),
tau2=seq(.05,.95,.05))
test.lige(out$cfa1, allt=igm$lfincome, h=0.5)
}

}
