% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bioactivity-APIs-batch.R
\name{get_annotation_by_aeid_batch}
\alias{get_annotation_by_aeid_batch}
\title{Retrieve annotations for AEID batch}
\usage{
get_annotation_by_aeid_batch(
  AEID = NULL,
  API_key = NULL,
  Server = NULL,
  rate_limit = 0L,
  verbose = FALSE
)
}
\arguments{
\item{AEID}{A list of AEID identifiers}

\item{API_key}{The user-specific API key}

\item{Server}{The root address for the API endpoint}

\item{rate_limit}{Number of seconds to wait between each request}

\item{verbose}{A logical indicating if some “progress report” should be given.}
}
\value{
A named list of data.frames containing annotation information for the
assays with AEID matching the input parameter.
}
\description{
Retrieve annotations for AEID batch
}
\examples{
\dontshow{if (has_ccte_key() & is.na(ccte_key() == 'FAKE_KEY')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Get annotations for multiple aeids
aeid_annotations <- get_annotation_by_aeid_batch(AEID = c(159, 160))
\dontshow{\}) # examplesIf}
}
