% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ccc_est_by_time.R
\name{ccc_est_by_time}
\alias{ccc_est_by_time}
\title{Concordance Correlation Coefficient estimation by variance components.}
\usage{
ccc_est_by_time(
  dataset,
  ry,
  rind,
  rmet,
  rtime,
  covar = NULL,
  int = F,
  cl = 0.95,
  control.lme = list(),
  future_seed = TRUE,
  transf = "F2",
  workers = 15,
  plotit = TRUE,
  test = FALSE,
  nboot = 500,
  adj.method = "holm",
  ...
)
}
\arguments{
\item{dataset}{an object of class \code{data.frame}.}

\item{ry}{Character string. Name of the outcome in the data set.}

\item{rind}{Character string. Name of the subject variable in the data set.}

\item{rmet}{Character string. Name of the method variable in the data set.}

\item{rtime}{Character string. Name of the time variable in the data set.}

\item{covar}{Character vector. Name of covariates to include in the linear mixed model as fixed effects.}

\item{int}{Binary indicating if the subject-method interaction has to be included in the model when analyzing the non-longitudinal setting (defaults to FALSE).}

\item{cl}{Confidence level.}

\item{control.lme}{A list of control values for the estimation algorithm used in \code{lme} function. For further details see \code{lme} help.}

\item{future_seed}{Logical/Integer. The seed to be used for parallellization. Further details in  \code{\link[furrr]{furrr_options}}.}

\item{transf}{Character string. Whether to apply a transformation of the coefficient for inference. Valid options are: "F" for Fisher's Z-transformation; "F2" For Fisher's Z-transformation setting m=2 (default); "KG" Konishi-Gupta transformation; "None", no transformation is applied. See *Details* for further information.}

\item{workers}{Integer. Number of cores to be used for parallellization. Default is 15. Capped to number of available cores minus 1.}

\item{plotit}{Logical. If TRUE it generates a plot with the CCC and their confidence intervals for each time.}

\item{test}{Logical. If TRUE the equality of CCCs is assessed. Default to FALSE.}

\item{nboot}{Number of bootstrap resamples.}

\item{adj.method}{Character string. Correction method for pairwise comparisons. See \code{\link[stats]{p.adjust}}}

\item{...}{To pass further arguments.}
}
\value{
A \code{ccc} class object. Generic function \code{summary} show a summary of the results. The output is a list with the following components:
\itemize{
 \item \code{ccc}. CCC estimates at each level of time variable.
 \item \code{plot}. Plot of the CCC along with their confidence intervals.
 \item \code{res_test}. Test of equality of CCCs.
 \item \code{ph_table}. Pairwise comparison of CCCs.
 }
}
\description{
Estimation of the non-longitudinal concordance correlation coefficient at each time using the variance components approach.
}
\details{
The concordance correlation coefficient is estimated using the variance components approach. Confidence intervals are built using the asymptotic Normal distribution approach.
Variance-covariance matrix of CCC estimates is estimated by non-parametric balanced randomized cluster bootstrap approach (Davison and Hinkley, 1997; Field and Welsh, 2007).
Overall equality of CCCs is tested following the non-parametric bootstrap approach suggested in  Vanbelle (2017).
}
\examples{

\dontrun{
ccc_est_by_time(bdaw, "AUC", "SUBJ", "MET", "VNUM")
ccc_est_by_time(bpres, "SIS", "ID", "METODE", "NM",test=TRUE)
}
}
\references{
{
 
Davison A.C., Hinkley D.V. (1997). Bootstrap Methods and Their Application. Cambridge: Cambridge University Press.
 
Field, C.A., Welsh, A.H. (2007). Bootstrapping Clustered Data. Journal of the Royal Statistical Society. Series B (Statistical Methodology) 69(3):369-390.

Vanbelle S. (2017). Comparing dependent kappa coefficients obtained on multilevel data. Biometrical Journal 59(5):1016-1034. 
 
}
}
