% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/reg_est.R
\name{reg_est}
\alias{reg_est}
\title{The regression prediction estimator}
\usage{
reg_est(Y,
        treat,
        covar_formula,
        covar_lin_formula = NULL,
        covar_sq_formula = NULL,
        data,
        degree,
        wt = NULL,
        method = "same")
}
\arguments{
\item{Y}{is the the name of the outcome variable contained in \code{data}.}

\item{treat}{is the name of the treatment variable contained in
\code{data}.}

\item{covar_formula}{is the formula to describe the covariates needed
to estimate the constant term:
\code{~ X.1 + ....}. Can include higher order terms or interactions.  i.e.
\code{~ X.1 + I(X.1^2) + X.1 * X.2 + ....}.  Don't forget the tilde before
listing the covariates.}

\item{covar_lin_formula}{is the formula to describe the covariates needed
to estimate the linear term, t:
\code{~ X.1 + ....}. Can include higher order terms or interactions.  i.e.
\code{~ X.1 + I(X.1^2) + X.1 * X.2 + ....}.  Don't forget the tilde before
listing the covariates.}

\item{covar_sq_formula}{is the formula to describe the covariates needed
to estimate the quadratic term, t^2:
\code{~ X.1 + ....}. Can include higher order terms or interactions.  i.e.
\code{~ X.1 + I(X.1^2) + X.1 * X.2 + ....}.  Don't forget the tilde before
listing the covariates.}

\item{data}{is a dataframe containing \code{Y}, \code{treat}, and
\code{X}.}

\item{degree}{is 1 for linear and 2 for quadratic outcome model.}

\item{wt}{is weight used in lsfit for outcome regression.
Default is wt = NULL.}

\item{method}{is "same" if the same set of covariates are used to estimate
the constant, linear, and/or quadratic term.  If method = "different", then
different sets of covariates can be used to estimate the constant, linear,
and/or quadratic term.  covar_lin_formula and covar_sq_formula must be specified
if method = "different".}
}
\value{
\code{reg_est} returns an object of class "causaldrf_lsfit",
a list that contains the following components:
\item{param}{the estimated parameters.}
\item{out_mod}{the result of the outcome model fit using lsfit.}
\item{call}{the matched call.}
}
\description{
This method estimates the linear or quadratic parameters of the ADRF by
estimating a least-squares fit on the basis functions which are composed of
combinations of the covariates and treatment values.
}
\details{
This function estimates the ADRF by the method described in Schafer and Galagate (2015)
that fits an outcome model using a function of the covariates.
}
\examples{
## Example from Schafer (2015).

example_data <- sim_data

reg_list <- reg_est(Y = Y,
                    treat = T,
                    covar_formula = ~ B.1 + B.2 + B.3 + B.4 + B.5 + B.6 + B.7 + B.8,
                    covar_lin_formula = ~ 1,
                    covar_sq_formula = ~ 1,
                    data = example_data,
                    degree = 1,
                    wt = NULL,
                    method = "same")

sample_index <- sample(1:1000, 100)

plot(example_data$T[sample_index],
      example_data$Y[sample_index],
      xlab = "T",
      ylab = "Y",
      main = "regression estimate")

abline(reg_list$param[1],
        reg_list$param[2],
        lty = 2,
        col = "blue",
        lwd = 2)

legend('bottomright',
        "regression estimate",
        lty = 2,
        bty = 'Y',
        cex = 1,
        col = "blue",
        lwd = 2)

rm(example_data, reg_list, sample_index)
}
\references{
Schafer, J.L., Galagate, D.L. (2015).  Causal inference with a
continuous treatment and outcome: alternative estimators for parametric
dose-response models. \emph{Manuscript in preparation}.

Schafer, Joseph L, Kang, Joseph (2008).  Average causal effects from
nonrandomized studies: a practical guide and simulated example.
\emph{Psychological methods}, \bold{13.4}, 279.
}
\seealso{
\code{\link{iptw_est}}, \code{\link{ismw_est}},
\code{\link{aipwee_est}}, \code{\link{wtrg_est}},
etc. for other estimates.

\code{\link{t_mod}}, \code{\link{overlap_fun}} to prepare the \code{data}
for use in the different estimates.
}

