% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\encoding{UTF-8}
\name{scorecard}
\alias{scorecard}
\title{Earnings and Loan Repayment in US Four-Year Colleges}
\format{
A data frame with 48,445 rows and 8 variables:
\describe{
  \item{unitid}{College identifiers}
  \item{inst_name}{Name of the college or university}
  \item{state_abbr}{Two-letter abbreviation for the state the college is in}
  \item{pred_degree_awarded_ipeds}{Predominant degree awarded. 1 = less-than-two-year, 2 = two-year, 3 = four-year+}
  \item{year}{Year in which outcomes are measured}
  \item{earnings_med}{Median earnings among students (a) who received federal financial aid, (b) who began as undergraduates at the institution ten years prior, (c) with positive yearly earnings}
  \item{count_not_working}{Number of students who are (a) not working (not necessarily unemployed), (b) received federal financial aid, and (c) who began as undergraduates at the institution ten years prior}
  \item{count_working}{Number of students who are (a) working, (b) who received federal financial aid, and (c) who began as undergraduates at the institution ten years prior}
}
}
\source{
Education Data Portal (Version 0.4.0 - Beta), Urban Institute, Center on Education Data and Policy, accessed June 28, 2019. \url{https://educationdata.urban.org/documentation/}, Scorecard.
}
\usage{
scorecard
}
\description{
From the College Scorecard, this data set contains by-college-by-year data on how students who attended those colleges are doing.
}
\details{
This data is not just limited to four-year colleges and includes a very wide variety of institutions.

Note that the labor market (earnings, working) and repayment rate data do not refer to the same cohort of students, but rather are matched on the year in which outcomes are recorded. Labor market data refers to cohorts beginning college as undergraduates ten years prior, repayment rate data refers to cohorts entering repayment seven years prior.

Data was downloaded using the Urban Institute's \code{educationdata} package.

This data was used in the \emph{Describing Variables} chapter of The Effect by Huntington-Klein
}
\references{
Huntington-Klein. 2021. The Effect: An Introduction to Research Design and Causality. \url{https://theeffectbook.net}.
}
\keyword{datasets}
