% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cotClass.R
\name{cotOptions}
\alias{cotOptions}
\title{Options available for the COT method}
\usage{
cotOptions(
  lambda = NULL,
  delta = NULL,
  opt.direction = c("dual", "primal"),
  debias = TRUE,
  p = 2,
  cost.function = NULL,
  cost.online = "auto",
  diameter = NULL,
  balance.formula = NULL,
  quick.balance.function = TRUE,
  grid.length = 7L,
  torch.optimizer = torch::optim_rmsprop,
  torch.scheduler = torch::lr_multiplicative,
  niter = 2000,
  nboot = 100L,
  lambda.bootstrap = 0.05,
  tol = 1e-04,
  device = NULL,
  dtype = NULL,
  ...
)
}
\arguments{
\item{lambda}{The penalty parameter for the entropy penalized optimal transport. Default is NULL. Can be a single number or a set of numbers to try.}

\item{delta}{The bound for balancing functions if they are being used. Only available for biased entropy penalized optimal transport. Can be a single number or a set of numbers to try.}

\item{opt.direction}{Should the optimizer solve the primal or dual problems. Should be one of "dual" or "primal" with a default of "dual" since it is typically faster.}

\item{debias}{Should debiased optimal transport be used? TRUE or FALSE.}

\item{p}{The power of the cost function to use for the cost.}

\item{cost.function}{A function to calculate the pairwise costs. Should take arguments \code{x1}, \code{x2}, and \code{p}. Default is NULL.}

\item{cost.online}{Should an online cost algorithm be used? One of "auto", "online", or "tensorized". "tensorized" is the offline option.}

\item{diameter}{The diameter of the covariate space, if known. Default is NULL.}

\item{balance.formula}{Formula for the balancing functions.}

\item{quick.balance.function}{TRUE or FALSE denoting whether balance function constraints should be selected via a linear program (TRUE) or just checked for feasibility (FALSE). Default is TRUE.}

\item{grid.length}{The number of penalty parameters to explore in a grid search if none are provided in arguments \code{lambda} or \code{delta}.}

\item{torch.optimizer}{The torch optimizer to use for methods using debiased entropy penalized optimal transport. If \code{debiased} is FALSE or \code{opt.direction} is "primal", will default to \code{\link[torch:optim_lbfgs]{torch::optim_lbfgs()}}. Otherwise \code{\link[torch:optim_rmsprop]{torch::optim_rmsprop()}} is used.}

\item{torch.scheduler}{The scheduler for the optimizer. Defaults to \code{\link[torch:lr_multiplicative]{torch::lr_multiplicative()}}.}

\item{niter}{The number of iterations to run the solver}

\item{nboot}{The number of iterations for the bootstrap to select the final penalty parameters.}

\item{lambda.bootstrap}{The penalty parameter to use for the bootstrap hyperparameter selection of lambda.}

\item{tol}{The tolerance for convergence}

\item{device}{An object of class \code{torch_device} denoting which device the data will be located on. Default is NULL which will try to use a gpu if available.}

\item{dtype}{An object of class \code{torch_dtype} that determines data type of the data, i.e. double, float, integer. Default is NULL which will try to select for you.}

\item{...}{Arguments passed to the solvers. See details}
}
\value{
A list of class \code{cotOptions} with the following slots
\itemize{
\item \code{lambda}The penalty parameter for the optimal transport distance
\item \code{delta}The constraint for the balancing functions
\item \code{opt.direction} Whether to solve the primal or dual optimization problems
\item \code{debias}TRUE or FALSE if debiased optimal transport distances are used
\item \code{balance.formula} The formula giving how to generate the balancing functions.
\item \code{quick.balance.function} TRUE or FALSE whether quick balance functions will be run.
\item \code{grid.length} The number of parameters to check in a grid search of best parameters
\item \code{p} The power of the cost function
\item \code{cost.online} Whether online costs are used
\item \code{cost.function} The user supplied cost function if supplied.
\item \code{diameter} The diameter of the covariate space.
\item \code{torch.optimizer} The \code{torch} optimizer used for Sinkhorn Divergences
\item \code{torch.scheduler} The scheduler for the \code{torch} optimizer
\item \code{solver.options} The arguments to be passeed to the \code{torch.optimizer}
\item \code{scheduler.options} The arguments to be passeed to the \code{torch.scheduler}
\item \code{osqp.options} Arguments passed to the \code{osqp} function if quick balance functions are used.
\item \code{niter} The number of iterations to run the solver
\item \code{nboot} The number of bootstrap samples
\item \code{lambda.bootstrap} The penalty parameter to use for the bootstrap hyperparameter selection.
\item \code{tol} The tolerance for convergence.
\item \code{device} An object of class \code{torch_device}.
\item \code{dtype} An object of class \code{torch_dtype}.
}
}
\description{
Options available for the COT method
}
\section{Solvers and distances}{
The function is setup to direct the COT optimizer to run two basic methods: debiased entropy penalized optimal transport (Sinkhorn Divergences) or entropy penalized optimal transport (Sinkhorn Distances).
\subsection{Sinkhorn Distances}{

The optimal transport problem solved is \eqn{min_w OT_\lambda(w,b) } where \deqn{OT_\lambda(w,b) = \sum_{ij} C(x_i, x_j) P_{ij} + \lambda \sum_{ij} P_{ij}\log(P_{ij}),} such that the rows of the matrix \eqn{P_{ij}} sum to \eqn{w} and the columns sum to \eqn{b}. In this case \eqn{C(,)} is the cost between units i and j.
}

\subsection{Sinkhorn Divergences}{

The Sinkhorn Divergence solves \deqn{min_w OT_\lambda(w,b) - 0.5 OT_\lambda(w,w) - 0.5 * OT_\lambda(b,b).} The solver for this function uses the \code{torch} package in \code{R} and by default will use the \code{optim_rmsprop} solver. Your desired \code{torch} optimizer can be passed via \code{torch.optimizer} with a scheduler passed via \code{torch.scheduler}. GPU support is available as detailed in the \code{torch} package. Additional arguments in \code{...} are passed as extra arguments to the \code{torch} optimizer and schedulers as appropriate.
}
}

\section{Function balancing}{
There may be certain functions of the covariates that we wish to balance within some tolerance, \eqn{\delta}. For these functions \eqn{B}, we will desire
\deqn{\frac{\sum_{i: Z_i = 0} w_i B(x_i) - \sum_{j: Z_j = 1} B(x_j)/n_1}{\sigma} \leq \delta}, where in this case we are targeting balance with the treatment group for the ATT. \eqn{\sigma} is the pooled standard deviation prior to balancing.
}

\section{Cost functions}{
The cost function specifies pairwise distances. If argument \code{cost.function} is NULL, the function will default to using \eqn{L_p^p} distances with a default \eqn{p = 2} supplied by the argument \code{p}. So for \code{p = 2}, the cost between units \eqn{x_i} and \eqn{x_j} will be \deqn{C(x_i, x_j) = \frac{1}{2} \| x_i - x_j \|_2^2.}
If \code{cost.function} is provided, it should be a function that takes arguments \code{x1}, \code{x2}, and \code{p}: \code{function(x1, x2, p){...}}.
}

\examples{
if ( torch::torch_is_installed()) {
opts1 <- cotOptions(lambda = 1e3, torch.optimizer = torch::optim_rmsprop)
opts2 <- cotOptions(lambda = NULL)
opts3 <- cotOptions(lambda = seq(0.1, 100, length.out = 7))
}
}
