% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cata.R
\encoding{UTF-8}
\name{code.topk}
\alias{code.topk}
\title{Apply top-k box coding to scale data}
\usage{
code.topk(X, zero.below = 8, one.above = 7)
}
\arguments{
\item{X}{input matrix}

\item{zero.below}{default is \code{8}; values below this numeric threshold 
will be coded \code{0}; use \code{NULL} if there is no such threshold}

\item{one.above}{default is \code{7}; values above this numeric threshold 
will be coded \code{1}; use \code{NULL} if there is no such threshold}
}
\value{
matrix \code{X} with top-k coding applied
}
\description{
Apply top-k box coding to scale data. Using defaults give top-2 box (T2B) coding.
}
\examples{
# Generate some data
set.seed(123)
X <- matrix(sample(1:9, 100, replace = TRUE), nrow = 5)

# apply top-2 box (T2B) coding
code.topk(X, zero.below = 8, one.above = 7)
}
\references{
Castura, J.C., Meyners, M., Pohjanheimo, T., Varela, P., & Næs, T. (2023). 
An approach for clustering consumers by their top-box and top-choice responses. 
\emph{Journal of Sensory Studies}, e12860. \doi{10.1111/joss.12860}
}
