% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_instance.R
\name{generate_instance_lfc}
\alias{generate_instance_lfc}
\title{Generate data sets under least favorable parameter configurations}
\usage{
generate_instance_lfc(
  nrep = 10,
  n = 100,
  prev = 0.5,
  random = FALSE,
  m = 10,
  se = 0.8,
  sp = 0.8,
  L = 1,
  rhose = 0,
  rhosp = 0,
  cortype = "equi",
  ...,
  data = NULL,
  job = NULL
)
}
\arguments{
\item{nrep}{integer, number of instances}

\item{n}{integer, total sample size}

\item{prev}{numeric, disease prevalence}

\item{random}{logical, fixed prevalence (FALSE) or simple random sampling (TRUE)}

\item{m}{integer, number of candidates}

\item{se}{numeric}

\item{sp}{numeric}

\item{L}{numeric}

\item{rhose}{numeric}

\item{rhosp}{numeric}

\item{cortype}{character, "equi" or "ak1"}

\item{...}{further arguments}

\item{data}{ignored (for batchtools compatibility)}

\item{job}{ignored (for batchtools compatibility)}
}
\value{
a list, a single (LFC) simulation instance
}
\description{
Generates a (simulation) instance, a list of multiple datasets to be processed
(analyzed) with \link{process_instance}. Ground truth parameters (Sensitvity & Specificity) are
least-favorable in the sense that the type-I error rate of the subsequently applied
multiple test procedures is maximized.
}
\details{
Utilizes same arguments as \link{draw_data_lfc} unless mentioned above.
}
