% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Common.R
\name{dtempirical}
\alias{dtempirical}
\alias{ptempirical}
\alias{qtempirical}
\alias{rtempirical}
\title{Density function of truncated empirical distribution}
\usage{
dtempirical(x, cdf, min = 0, max = 1e+09)

ptempirical(q, cdf, min = 0, max = 1e+05)

qtempirical(p, cdf, min = 0, max = 1e+05)

rtempirical(n, cdf, min = 0, max = 1e+05)
}
\arguments{
\item{x}{Value of the variable after deductible and limit max(0,min(claim,limit)-deductible)}

\item{cdf}{empirical distribution (cdf for continuous distribution and pmf for discrete distribution)}

\item{min}{Left truncation deductible}

\item{max}{Right truncation limit}

\item{q}{Value of the variable after deductible and limit max(0,min(claim,limit)-deductible)}

\item{p}{Value of the probability}

\item{n}{Number of samples}
}
\description{
Density function of truncated empirical distribution

Cumulative probability function of truncated empirical distribution

Quantile function of truncated empirical distribution max(0,min(claim,limit)-deductible)

Random generation of Truncated empirical distribution max(0,min(claim,limit)-deductible)
}
\examples{
#discrete distribution
dtempirical(3,matrix(c(0.1,0.2,0.3,0.05,0.05,0.2,0.1,1:6,10),7,2),3,100)
#continuous distribution
dtempirical(30,matrix(c(seq(0.01,1,0.01),qnorm(seq(0.01,1,0.01),30,20)),100,2),200,10000000)
#discrete distribution
ptempirical(c(3,5,10),matrix(c(0.1,0.2,0.3,0.05,0.05,0.2,0.1,1:6,10),7,2),3,100)
#continuous distribution
ptempirical(350,matrix(c(seq(0.01,1,0.01),cumprod(c(1,rep(1.1,99)))),100,2),200,10000000)
#discrete distribution
qtempirical(c(0.3,0.65,1),matrix(c(0.1,0.2,0.3,0.05,0.05,0.2,0.1,1:6,10),7,2),3,100)
#continuous distribution
qtempirical(c(0.3,0.65,0.8),matrix(c(seq(0.01,1,0.01),
cumprod(c(1,rep(1.1,99)))),100,2),200,10000000)
#discrete distribution
rtempirical(100,matrix(c(0.1,0.2,0.3,0.05,0.05,0.2,0.1,1:6,10),7,2),3,100)
#continuous distribution
rtempirical(100,matrix(c(seq(0.01,1,0.01),cumprod(c(1,rep(1.1,99)))),100,2),200,10000000)
}
