% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Copula.R
\docType{methods}
\name{setCopulaParam<-}
\alias{setCopulaParam<-}
\alias{setCopulaParam<-,CopulaObj,numeric-method}
\alias{setCopulaParam,ANY-method}
\title{Set copula parameters.}
\usage{
setCopulaParam(this, ...) <- value

\S4method{setCopulaParam}{CopulaObj,numeric}(this) <- value
}
\arguments{
\item{this}{Copula Object}

\item{...}{Additional function arguments}

\item{value}{The copula parameters}
}
\description{
Set copula parameters.
}
\examples{
library(cascsim)
dist1<-new("Pareto",p1=20,p2=3)
dist2<-new("Normal",p1=5,p2=3,min=0,max=20,truncated=TRUE)
cop <- new("CopulaObj", param=c(0.5),marginal=list(dist1=dist1,dist2=dist2),dimension=2)
setCopulaParam(cop) <- 0.6
}
