% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/carx_default.R
\name{AIC.carx}
\alias{AIC.carx}
\title{Compute the  AIC of a fitted \code{carx} object}
\usage{
\method{AIC}{carx}(object, ..., k = 2)
}
\arguments{
\item{object}{a fitted  \code{carx} object.}

\item{...}{not used.}

\item{k}{penalty multiplier for the number of parameters. Default = 2.}
}
\value{
the AIC value = -2*maximum quasi-log-likelihood+k*number of parameters
}
\description{
Return the AIC of a fitted \code{carx} object where the maximum log-likelihood is replaced by the 
maximum quasi-log-likelihood.
}
\examples{
dat = carxSim(nObs=100,seed=0)
mdl <- carx(y~X1+X2-1,data=dat, p=2, CI.compute = FALSE)
ic = AIC(mdl)
}

