% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legends.R
\name{legendCirclesSymbols}
\alias{legendCirclesSymbols}
\title{Legend for Proportional Circles Maps}
\usage{
legendCirclesSymbols(pos = "topleft",
  title.txt = "Title of the legend", title.cex = 0.8, cex = 1,
  border = "black", lwd = 1, values.cex = 0.6, var, inches,
  col = "#E84923", frame = FALSE, values.rnd = 0, style = "c")
}
\arguments{
\item{pos}{position of the legend, one of "topleft", "top", 
"topright", "right", "bottomright", "bottom", "bottomleft", 
"bottomleftextra", "left" or a vector of two coordinates in map units 
(c(x, y)).}

\item{title.txt}{title of the legend.}

\item{title.cex}{size of the legend title.}

\item{cex}{size of the legend. 2 means two times bigger.}

\item{border}{color of the borders.}

\item{lwd}{width of the borders.}

\item{values.cex}{size of the values in the legend.}

\item{var}{vector of values (at least min and max).}

\item{inches}{radii of the biggest circle.}

\item{col}{color of symbols.}

\item{frame}{whether to add a frame to the legend (TRUE) or 
not (FALSE).}

\item{values.rnd}{number of decimal places of the values in 
the legend.}

\item{style}{either "c" or "e". The legend has two display 
styles, "c" stands for compact and "e" for extended.}
}
\description{
Plot legend for proportional circles maps
}
\examples{
library(sf)
mtq <- st_read(system.file("gpkg/mtq.gpkg", package="cartography"))
plot(st_geometry(mtq))
box()

propSymbolsLayer(x = mtq, var = "POP",
                 inches = 0.2, legend.pos = "n")

legendCirclesSymbols(pos = "topleft", inches = 0.2,
                     var = c(min(mtq$POP), max(mtq$POP)))
legendCirclesSymbols(pos = "left",
                     var = c(min(mtq$POP), max(mtq$POP)),
                     inches = 0.2, style = "e")
legendCirclesSymbols(pos = "bottomleft",
                     var = c(600, 12000, 40000, max(mtq$POP)),
                     inches = 0.2, style = "c")
legendCirclesSymbols(pos = "topright", cex = 2,
                     var = c(600, 30000,max(mtq$POP)),
                     inches = 0.2, style = "e", frame = TRUE)
legendCirclesSymbols(pos = c(736164.4, 1596658),
                     var = c(min(mtq$POP),max(mtq$POP)),
                     inches = 0.2, frame = TRUE)
}
