% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input_sdm.R
\name{input_sdm}
\alias{input_sdm}
\alias{add_input_sdm}
\title{\code{input_sdm}}
\usage{
input_sdm(...)

add_input_sdm(i1, i2)
}
\arguments{
\item{...}{Data to be used in SDMs. Can be a \code{occurrences} and/or a \code{sdm_area} object.}

\item{i1}{A \code{input_sdm} object.}

\item{i2}{A \code{input_sdm} object.}
}
\value{
A \code{input_sdm} object containing:
   \item{grid}{\code{sf} with POLYGON geometry representing the grid for the study area or
   LINESTRING if \code{sdm_area} was built with a LINESTRING \code{sf}.}
   \item{bbox}{Four corners for the bounding box (class \code{bbox}): minimum value of X, minimum
   value of Y, maximum value of X, maximum value of Y}
   \item{cell_size}{\code{numeric} information regarding the size of the cell used to rescale
   variables to the study area, representing also the cell size in the \code{grid}.}
   \item{epsg}{\code{character} information about the EPSG used in all slots from \code{sdm_area}.}
   \item{predictors}{\code{character} vector with predictors names included in \code{sdm_area}.}
}
\description{
This function creates a new \code{input_sdm} object.
}
\details{
If \code{sdm_area} is used, it can include predictors and scenarios. In this case,
\code{input_sdm} will detect and include as \code{scenarios} and \code{predictors} in the
\code{input_sdm} output. Objects can be included in any order, since the function will work by
detecting their classes.
The returned object is used throughout the whole workflow to apply functions.
}
\examples{
# Create sdm_area object:
sa <- sdm_area(parana, cell_size = 50000, crs = 6933)

# Include predictors:
sa <- add_predictors(sa, bioc) |> select_predictors(c("bio1", "bio4", "bio12"))

# Include scenarios:
sa <- add_scenarios(sa, scen)

# Create occurrences:
oc <- occurrences_sdm(occ, crs = 6933) |> join_area(sa)

# Create input_sdm:
i <- input_sdm(oc, sa)

}
\seealso{
\code{\link{occurrences_sdm} \link{sdm_area}}
}
\author{
Luiz Fernando Esser (luizesser@gmail.com)
https://luizfesser.wordpress.com
}
