% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_survival_survdiff.R
\name{ard_survival_survdiff}
\alias{ard_survival_survdiff}
\title{ARD for Difference in Survival}
\usage{
ard_survival_survdiff(formula, data, rho = 0, ...)
}
\arguments{
\item{formula}{(\code{formula})\cr
a formula}

\item{data}{(\code{data.frame})\cr
a data frame}

\item{rho}{(\verb{scalar numeric})\cr
numeric scalar passed to \code{survival::survdiff(rho)}. Default is \code{rho=0}.}

\item{...}{additional arguments passed to \code{survival::survdiff()}}
}
\value{
an ARD data frame of class 'card'
}
\description{
Analysis results data for comparison of survival using \code{\link[survival:survdiff]{survival::survdiff()}}.
}
\examples{
\dontshow{if (do.call(asNamespace("cardx")$is_pkg_installed, list(pkg = c("survival", "broom", "ggsurvfit")))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(survival)
library(ggsurvfit)

ard_survival_survdiff(Surv_CNSR(AVAL, CNSR) ~ TRTA, data = cards::ADTTE)
\dontshow{\}) # examplesIf}
}
