% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fepoisson.R
\name{fepoisson}
\alias{fepoisson}
\title{Poisson model fitting high-dimensional with k-way fixed effects}
\usage{
fepoisson(
  formula = NULL,
  data = NULL,
  weights = NULL,
  beta_start = NULL,
  eta_start = NULL,
  control = NULL
)
}
\arguments{
\item{formula}{an object of class \code{"formula"}: a symbolic description of
the model to be fitted. \code{formula} must be of type \code{y ~ x | k},
where the second part of the formula refers to factors to be concentrated
out. It is also possible to pass clustering variables to \code{\link{feglm}}
as \code{y ~ x | k | c}.}

\item{data}{an object of class \code{"data.frame"} containing the variables
in the model. The expected input is a dataset with the variables specified
in \code{formula} and a number of rows at least equal to the number of
variables in the model.}

\item{weights}{an optional string with the name of the 'prior weights'
variable in \code{data}.}

\item{beta_start}{an optional vector of starting values for the structural
parameters in the linear predictor. Default is
\eqn{\boldsymbol{\beta} = \mathbf{0}}{\beta = 0}.}

\item{eta_start}{an optional vector of starting values for the linear
predictor.}

\item{control}{a named list of parameters for controlling the fitting
process. See \code{\link{feglm_control}} for details.}
}
\value{
A named list of class \code{"feglm"}.
}
\description{
A wrapper for \code{\link{feglm}} with
\code{family = poisson()}.
}
\examples{
# check the feglm examples for the details about clustered standard errors
mod <- fepoisson(mpg ~ wt | cyl, mtcars)
summary(mod)

}
