% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/one_pairscan_parallel.R
\name{one_pairscan_parallel}
\alias{one_pairscan_parallel}
\title{This is an internal function to run a single pairscan
It is used both to do the actual pairscan 
(\code{\link{pairscan_kin}} and \code{\link{pairscan_noKin}}), 
as well as to do the permutations of the pairscan
\code{\link{pairscan_null}}).}
\usage{
one_pairscan_parallel(
  data_obj,
  phenotype_vector,
  genotype_matrix,
  int = NULL,
  covar_vector = NULL,
  paired_markers,
  n_perm = 0,
  run_parallel = FALSE,
  verbose = FALSE,
  n_cores = 4
)
}
\arguments{
\item{data_obj}{a \code{\link{Cape}} object}

\item{phenotype_vector}{A vector of trait values}

\item{genotype_matrix}{A matrix of genotypes for markers to
be tested}

\item{int}{the interaction term added to the linear model
when the kinship correction is being used. This term is
calculated in \code{\link{pairscan_kin}}.}

\item{covar_vector}{a vector or matrix of covariates to
be used.}

\item{paired_markers}{a two-column matrix indicating which
marker pairs should be tested. The pairs are assigned in
\code{\link{pairscan}} by \code{\link{get_pairs_for_pairscan}}.
They are checked for pairwise correlations before being sent
to the pairscan.}

\item{n_perm}{the number of permutations to be performed.}

\item{run_parallel}{a logical value indicating whether to 
use parallel computing}

\item{verbose}{a logical value indicating whether progress should
be printed to the screen.}

\item{n_cores}{the number of CPUs to use if run_parallel is TRUE.}
}
\value{
This function returns a list with two slots: 
pairscan_results and pairscan_perm
Each of these elements is also a list containing effect
sizes, standard errors, and covariance matrices for the
pairwise tests.
}
\description{
This is an internal function to run a single pairscan
It is used both to do the actual pairscan 
(\code{\link{pairscan_kin}} and \code{\link{pairscan_noKin}}), 
as well as to do the permutations of the pairscan
\code{\link{pairscan_null}}).
}
\keyword{internal}
