\encoding{UTF-8}
\name{diffplot}
\alias{diffplot}
\title{Plot Compositional Differences}
\description{
  Make a plot showing differences and \emph{p}-values.
}

\usage{
  diffplot(comptab, vars = c("ZC", "nH2O"), col = "black",
           plot.rect = FALSE, pt.text = c(letters, LETTERS))
}

\arguments{
  \item{comptab}{list or data frame, summary of comparisons generated by \code{\link{get_comptab}}}
  \item{vars}{character, which variables to plot}
  \item{col}{the color(s) for points}
  \item{plot.rect}{plot a reference rectangle?}
  \item{pt.text}{text labels for the points}
}

\details{

A plot is created with points showing the differences in medians or means of two compositional metrics.
The default setting of \code{vars} refers to average oxidation state of carbon (\ZC) as the x-variable and water demand per residue in formation reactions from basis species (\nH2O{&#772}) as the y-variable.

For each dataset, the point symbol is a filled square if the \emph{p}-values of both the x-variable and y-variable are less than 0.05, a filled circle if the \emph{p}-value of one of the x- or y-variables is less than 0.05, and an open circle otherwise.

A solid line is drawn from the point to the corresponding axis if the rounded, absolute value of (\code{\link{CLES}} in percent - 50) of the x- or y-variable is greater than or equal 10.
Otherwise, a dashed line is drawn from the point to the corresponding axis if the \emph{p}-value of the x- or y-variable is less than 0.05.
Otherwise, no line is drawn.

The colors of the points are controlled by \code{col}, which is recycled to be equal to the number of comparisons in \code{comptab}.

If \code{plot.rect} is TRUE, a shaded \code{\link{rect}}angle is drawn with coordinates -0.01, -0.01, 0.01, 0.01.
This is useful for emphasizing the different scales of adjacent plots.

If \code{pt.text} is not NA or FALSE, the points are plotted in a bigger size and \code{\link{text}} labels are added.
The default value produces labels that are taken sequentially from 26 lowercase Roman letters in alphabetical order (\code{\link{letters}}), followed by the set of uppercase letters (\code{\link{LETTERS}}).

}

\examples{
data(canprot)
comptab <- lapply(c("JKMF10", "WDO+15_C.N"), function(dataset) {
  pdat <- get_pdat(dataset)
  get_comptab(pdat)
})
diffplot(comptab)
}

\concept{Chemical composition}
