% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/census_vectors.R
\name{child_census_vectors}
\alias{child_census_vectors}
\title{List all child variables from vector hierarchies given either a list of Census
variables returned by
\code{list_census_vectors} or \code{search_census_vectors}, or a direct string reference to the vector code.}
\usage{
child_census_vectors(vector_list, leaves_only = FALSE, max_level = NA)
}
\arguments{
\item{vector_list}{The list of vectors to be used, either a character vector or a filtered tibble
as returned from \code{list_census_vectors}.}

\item{leaves_only}{Boolean flag to indicate if only leaf vectors should be returned,
i.e. vectors that don't have children.}

\item{max_level}{optional, maximum depth to look for child vectors. Default is NA will return all
child census vectors.}
}
\description{
List all child variables from vector hierarchies given either a list of Census
variables returned by
\code{list_census_vectors} or \code{search_census_vectors}, or a direct string reference to the vector code.
}
\examples{
# Query parent vectors directly using vector identifier
child_census_vectors("v_CA16_2510")

\dontrun{

# Example using multiple vectors coerced into a list
child_census_vectors(c("v_CA16_2510","v_CA16_2511","v_CA16_2512"))

# or, equivalently
selected_vectors <- c("v_CA16_2510","v_CA16_2511","v_CA16_2512")
child_census_vectors(selected_vectors)

# Example using dplyr and piped arguments
library(dplyr, warn.conflicts = FALSE)

list_census_vectors("CA16") \%>\%
  filter(vector == "v_CA16_2510") \%>\%
  child_census_vectors(TRUE)
}

}
