% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch-city.R
\name{fetch_city}
\alias{fetch_city}
\title{Return Closest Match Result of Cities from Google Maps API}
\usage{
fetch_city(address = NULL, key = NULL)
}
\arguments{
\item{address}{A vector of street addresses. Sent to the API as one string.}

\item{key}{A character containing your alphanumeric Google Maps API key.}
}
\value{
A character vector of formatted address endpoints from Google. This
will include all the fields from street address, city, state/province,
zipcode/postal code to country/regions. \code{NA_character_} is returned for
all errored API calls.
}
\description{
Use the \code{\link[httr:GET]{httr::GET()}} to send a request to the Google Maps API for geocoding
information. The query will concatenate all the geographical information that
is passed in into a single string. Then the function pulls the
\code{formatted_address} endpoint of the API results and extracts the the first
field of the result. Note that you will need to pass in your Google Maps
Place API key with the \code{key} argument.
}
\seealso{
\url{http://code.google.com/apis/maps/documentation/geocoding/}

Other geographic normalization functions: 
\code{\link{abbrev_full}()},
\code{\link{abbrev_state}()},
\code{\link{check_city}()},
\code{\link{expand_abbrev}()},
\code{\link{expand_state}()},
\code{\link{normal_address}()},
\code{\link{normal_city}()},
\code{\link{normal_state}()},
\code{\link{normal_zip}()},
\code{\link{str_normal}()}
}
\concept{geographic normalization functions}
