% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add-prop.R
\name{add_prop}
\alias{add_prop}
\title{Add proportions}
\usage{
add_prop(.data, n, sum = FALSE)
}
\arguments{
\item{.data}{A data frame with a count column.}

\item{n}{The column name with a count, usually \code{n} from \code{\link[dplyr:count]{dplyr::count()}}.}

\item{sum}{Should \code{\link[=cumsum]{cumsum()}} be called on the new \code{p} column.}
}
\value{
A data frame with the new column \code{p}.
}
\description{
Use \code{\link[=prop.table]{prop.table()}} to add a proportion column to a \code{\link[dplyr:count]{dplyr::count()}} tibble.
}
\details{
\code{mean(x \%in\% y)}
}
\examples{
add_prop(dplyr::count(ggplot2::diamonds, cut))
}
