% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_calib.R
\name{plot.calib_blr}
\alias{plot.calib_blr}
\title{Plots calibration curves estimated using \code{\link{calib_blr}}.}
\usage{
\method{plot}{calib_blr}(x, ..., combine = TRUE, ncol = NULL, nrow = NULL, transparency.rug = 0.1)
}
\arguments{
\item{x}{Object of class 'calib_blr' generated from \code{\link{calib_blr}}.}

\item{...}{Other}

\item{combine}{Whether to combine into one plot using ggarrange, or return as a list of individual plots}

\item{ncol}{Number of columns for combined calibration plot}

\item{nrow}{Number of rows for combined calibration plot}

\item{transparency.rug}{Degree of transparency for the density rug plot along each axis}
}
\value{
If \code{combine = TRUE}, returns an object of classes \code{gg}, \code{ggplot}, and \code{ggarrange},
as all ggplots have been combined into one object. If \code{combine = FALSE}, returns an object of
class \code{list}, each element containing an object of class \code{gg} and \code{ggplot}.
}
\description{
Plots calibration curves for the transition probabilities of a multistate model
estimated using \code{\link{calib_blr}}.
}
\examples{
# Estimate and plot BLR-IPCW calibration curves for the predicted transition
# probabilities at time t = 1826, when predictions were made at time
# s = 0 in state j = 1. These predicted transition probabilities are stored in tps0.

# Extract the predicted transition probabilities out of state j = 1
tp.pred <- dplyr::select(dplyr::filter(tps0, j == 1), any_of(paste("pstate", 1:6, sep = "")))

# Now estimate the observed event probabilities for each possible transition.
dat.calib.blr <-
calib_blr(data.mstate = msebmtcal,
 data.raw = ebmtcal,
 j=1,
 s=0,
 t = 1826,
 tp.pred = tp.pred,
 w.covs = c("year", "agecl", "proph", "match"))

 # These are then plotted
 plot(dat.calib.blr, combine = TRUE, nrow = 2, ncol = 3)

}
